package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XzdyFwxxSdEntity;
import io.renren.modules.app.service.XzdyFwxxSdService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * APP接口demo
 *
 */
@RestController
@RequestMapping("/app/xzdyfwxxsd")
@Api(tags = "新增单元的房屋信息设定模块")
public class XzdyFwxxSdController {

	@Autowired
	private XzdyFwxxSdService xzdyFwxxSdService;
	
	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增单元房屋信息设定(保存)", notes = "", response = XzdyFwxxSdEntity.class)
	public R insert(@RequestBody XzdyFwxxSdEntity xzdyFwxxSdEntity) {
		// 将新增的房屋信息和新增的单元信息绑定
		xzdyFwxxSdService.insert(xzdyFwxxSdEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "编辑修改", notes = "", response = XzdyFwxxSdEntity.class)
	public R update(@RequestBody XzdyFwxxSdEntity xzdyFwxxSdEntity) {
		//根据房屋信息表中的mh(门号（单元编码）)编辑该房屋信息
		xzdyFwxxSdService.updateBymh(xzdyFwxxSdEntity);
		return R.ok();
	}
	
	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody String id) {

		return R.ok().put("select", xzdyFwxxSdService.selectxlk(id));
	}
	
	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = XzdyFwxxSdEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, XzdyFwxxSdEntity xzdyFwxxSdEntity) {

		return R.ok().put("data", xzdyFwxxSdService.queryByPage(pageNum, pageSize, xzdyFwxxSdEntity));
	}
	
	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = XzdyFwxxSdEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", xzdyFwxxSdService.selectById(id));
	}

}
