package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.renren.modules.app.dao.DyxxDao;
import io.renren.modules.app.entity.DyxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.service.DyxxService;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service("dyxxService")
public class DyxxServiceImpl extends ServiceImpl<DyxxDao, DyxxEntity> implements DyxxService {

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param dyxxEntity
	 * @return
	 */
	@Override
	public PageInfo<DyxxEntity> queryByPage(Integer pageNum, Integer pageSize, DyxxEntity dyxxEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<DyxxEntity> dyxxEntitys = baseMapper.queryByPage(dyxxEntity);
		PageInfo<DyxxEntity> pageInfo = new PageInfo<DyxxEntity>(dyxxEntitys);
		return pageInfo;
	}

	/**
	 * 单个或批量删除
	 * 
	 * @param ids
	 */
	@Override
	public void deleteBatch(String[] ids) {
		this.deleteBatchIds(Arrays.asList(ids));
	}

	// 小区下拉框数据展现
	@Override
	public List<XlkEntity> selectxlk(String id) {
		id=id.replace("\"", "");
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if ("01".equals(id)) {
			list = baseMapper.selectxlkxq();
		} 
		return list;
	}

	@Override
	public List<XlkEntity> selectDjld(Map<String,String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			//查询所有小区
			list = baseMapper.selectxlkxq();
		}else if("xqbm".equals(map.get("XQBM"))){
			list=baseMapper.selectxmbyxq(map.get("xqbmz"));
		}else if("xmbm".equals(map.get("XMBM"))){
			list=baseMapper.selectlzbyxm(map.get("xmbmz"));
		}else if("dhbm".equals(map.get("DHBM"))){
			list=baseMapper.selectdylcbylz(map.get("dhbmz"));
		}
		return list;
	}

	@Override
	public String queryfwdybm() {
		
		return baseMapper.queryfwdybm();
	}

    @Override
    public List<DyxxEntity> selectDybmList(List<String> dhbmList) {
        return baseMapper.selectDybmList(dhbmList);
    }

}