package io.renren.modules.app.service.impl;


import com.alibaba.druid.sql.ast.statement.SQLIfStatement.Else;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.renren.modules.app.dao.DyxxDao;
import io.renren.modules.app.dao.XlkDao;
import io.renren.modules.app.entity.DyxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.service.DyxxService;
import io.renren.modules.app.service.XlkService;

import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service("xlkService")
public class XlkServiceImpl extends ServiceImpl<XlkDao, XlkEntity> implements XlkService {

	

	@Override
	public List<XlkEntity> selectxlk(Map<String,String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			//查询所有小区
			list = baseMapper.selectxlkxq(null);
		}else if("xqbm".equals(map.get("XQBM"))){
			list=baseMapper.selectxm(map.get("xqbmz"));
		}else if("xmbm".equals(map.get("XMBM"))){
			list=baseMapper.selectlz(map.get("xmbmz"));
		}else if("kmlb".equals(map.get("KMLB"))){
			list=baseMapper.selectkmlb();
		}else if("kmlb2".equals(map.get("KMLB2"))){
			list=baseMapper.selectkmlbbyid(map.get("kmlbz"));
		}else if("dqkjqj".equals(map.get("DQKJQJ"))){
			list=baseMapper.selectkjqj();
		}else if("pzh".equals(map.get("PZH"))){
			list=baseMapper.selectpzh();
		}else if("fwxz".equals(map.get("FWXZ"))){
			list=baseMapper.selectfwxz(map.get("type"));
		}else if("dwjjl".equals(map.get("DWJJL"))){
			list=baseMapper.selectdwjjl(map);
		}else if("czyy".equals(map.get("CZYY"))){
			list=baseMapper.selectczyy();
		}else if("cwkjqj".equals(map.get("CWKJQJ"))){
			list=baseMapper.selectcwkjqj();
		}else if("jzszkm".equals(map.get("JZSZKM"))){
		    list=baseMapper.selectjzszkm();
		}else if("xmbmy".equals(map.get("XMBMY"))){
			list=baseMapper.selectjxmall(map.get("pt"));
		}else if("dwbyxm".equals(map.get("DWBYXM"))){
			list=baseMapper.selectDWBYXM(map.get("dwmcc"));
		}else if("dybmbyxm".equals(map.get("DYBMBYXM"))){
			list=baseMapper.selectDYBMBYXM(map.get("dybmz"));
		}else if("scdyxlk".equals(map.get("SCDYXLK"))){
			list=baseMapper.selectDYBMBYSQDBH(map.get("sqdbh"));
		}else if("yeldxlk".equals(map.get("YELDXLK"))){
			list=baseMapper.selectYELDXLK(map.get("sqdbh"));
		}else if("yedyxlk".equals(map.get("YEDYXLK"))){
			list=baseMapper.selectYEDYXLK(map.get("sqdbh"));
		}
		return list;
	}

	//分户明细账下拉框
	@Override
	public List<XlkEntity> selectFHMXxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if ("xmmc".equals(map.get("XMMC"))) {
			//查询所有项目
			list = baseMapper.selectXMxlk(map.get("pt"));
		}else if ("xmbm".equals(map.get("XMBM"))) {
			list = baseMapper.selectZHxlk(map.get("xmbm"));
		}else if ("dhbm".equals(map.get("DHBM"))) {
			list = baseMapper.selectMPHxlk(map.get("dhbm"));
		}
		return list;
	}

	//单元明细下拉框
	@Override
	public List<XlkEntity> selectDYMXxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.get("num").equals("1")) {
			//查询开发项目
			list = baseMapper.selectXMxlk(map.get("pt"));
		}else if (map.get("num").equals("2")) {
			//查询楼宇名称
			list = baseMapper.selectZHxlk(map.get("xmbm"));
		}else if (map.get("num").equals("3")) {
			//查询单元名称
			list = baseMapper.selectDYxlk(map.get("dhbm"));
		}
		return list;
	}

	//开发单位下拉框
	@Override
	public List<XlkEntity> selectKFDWxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		list = baseMapper.selectKFDWxlk(map.get("pt"));
		return list;
	}

	//综合明细账页面下拉框
	@Override
	public List<XlkEntity> selectZHMXZxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.get("num").equals("1")) {
			//小区
			list = baseMapper.selectxlkxq(map.get("pt"));
		}else if (map.get("num").equals("2")) {
			//项目
			list = baseMapper.selectXMxlk2(map.get("pt"));
		}else if (map.get("num").equals("3")) {
			//楼栋
			list = baseMapper.selectZHxlk(map.get("xmbm"));
		}else if (map.get("num").equals("4")) {
			//单元
			list = baseMapper.selectDYxlk(map.get("dhbm"));
		}else if (map.get("num").equals("5")) {
			//房屋
			list = baseMapper.selectMPHxlk2(map.get("mh"));
		}
		return list;
	}

	//楼幢信息下拉框
	@Override
	public List<XlkEntity> selectzhxxxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.get("num").equals("1")) {
			//物业公司
			list = baseMapper.selectwygs();
		}else if (map.get("num").equals("2")) {
			//业主委员会
			list = baseMapper.selectgwhxx();
		}else if (map.get("num").equals("3")) {
			//物业项目
			list = baseMapper.selectXMxlk2(map.get("pt"));
		}
		return list;
	}

}