package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.ZhxxtempDao;
import io.renren.modules.app.entity.ZhxxtempEntity;
import io.renren.modules.app.service.ZhxxtempService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("zhxxtempService")
public class ZhxxtempServiceImpl extends ServiceImpl<ZhxxtempDao, ZhxxtempEntity> implements ZhxxtempService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param zhxxtempEntity
     * @return
     */
    @Override
    public PageInfo<ZhxxtempEntity> queryByPage(Integer pageNum, Integer pageSize, ZhxxtempEntity zhxxtempEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<ZhxxtempEntity> zhxxtempEntitys = baseMapper.queryByPage(zhxxtempEntity);
        PageInfo<ZhxxtempEntity> pageInfo = new PageInfo<ZhxxtempEntity>(zhxxtempEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }


}