package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.GryjpldrtempEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzmxEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.GrwxzjService;
import io.renren.modules.app.service.GrwxzjfhService;
import io.renren.modules.sys.entity.SysUserEntity;
import io.renren.modules.sys.service.SysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import sun.misc.BASE64Encoder;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 个人维修资金
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/grwxzj")
@Api(tags = "个人维修资金模块")
public class GrwxzjController {

	private static String REGEX_CHINESE = "[\u4e00-\u9fa5]";// 中文正则1

	@Autowired
	private GrwxzjService grwxzjService;

	@Autowired
	private GrwxzjfhService grwxzjfhService;

	@Autowired
	private SysUserService sysUserService;

	// @Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("list", grwxzjService.selectxlk(map));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "保存", notes = "保存个人维修资金预交(批量勾选)", response = YwpzEntity.class)
	public R insert(@RequestBody List<YwpzEntity> list) {
		for (YwpzEntity y : list) {
			grwxzjService.insertGr(y);
			try {
				// 避免批量插入高并发，主键中的时间相同，导致主键冲突，此处设置每次停顿1秒
				Thread.currentThread().sleep(1000);
			} catch (InterruptedException e) {

				e.printStackTrace();
			}
		}

		return R.ok();
	}

	// @Login
	@PostMapping("/insertPLDR")
	@ApiOperation(value = "保存(批量导入)", notes = "将已经标记取到的fwbm批量导入业务表中并自动审核", response = YwpzEntity.class)
	public R insertPLDR() {
		List<GryjpldrtempEntity> listgr = grwxzjService.selectgryjpldryjfw();// 所有已经找到的房屋信息
		List<YwpzEntity> list = new ArrayList<YwpzEntity>();
		List<String> djbhlist = new ArrayList<String>();
		for (GryjpldrtempEntity gr : listgr) {
			YwpzEntity y1 = new YwpzEntity();
			y1.setDjrq(gr.getDjrq());
			y1.setKjqj(gr.getDjrq().substring(0, 7));
			y1.setCbwdbm("0001");
			y1.setZph(gr.getZph());
			y1.setJe(gr.getJe());
			y1.setCzybm("7");
			y1.setCzyxm("系统");
			if (!"".equals(gr.getBz()) && gr.getBz() != null) {
				y1.setBz(gr.getBz());
			}
			ZhxxEntity z = grwxzjService.selectdhdw(gr.getFwbm());
			y1.setDwbm(z.getDwbm());
			y1.setDhbm(z.getDhbm());
			y1.setFwbm(gr.getFwbm());
			if (gr.getMj() > 1000) {
				y1.setFwje(gr.getMj());
				y1.setMj(0.0);
			} else {
				y1.setMj(gr.getMj());
				y1.setFwje(0.0);
			}
			if (!"".equals(gr.getSjh()) && gr.getSjh() != null) {
				y1.setSjh(gr.getSjh());
			}
			y1.setGrjjl(gr.getGrjjl());
			if (!"".equals(gr.getYzxm()) && gr.getYzxm() != null) {
				y1.setXm(gr.getYzxm());
			}
			list.add(y1);
		}
		for (YwpzEntity y2 : list) {
			String djbh = grwxzjService.insertGrpldr(y2);
			try {
				// 避免批量插入高并发，主键中的时间相同，导致主键冲突，此处设置每次停顿1秒
				Thread.currentThread().sleep(1000);
			} catch (InterruptedException e) {

				e.printStackTrace();
			}
			djbhlist.add(djbh);
		}
		List<DhbmyjEntity> dhyjs = new ArrayList<DhbmyjEntity>();
		for (String djbh : djbhlist) {
			DhbmyjEntity d = new DhbmyjEntity();
			d.setDjbh(djbh);
			d.setShrbm("7");
			d.setShrxm("系统");
			dhyjs.add(d);
		}
		grwxzjfhService.updateFh(dhyjs);

		return R.ok();
	}

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "查询按钮", notes = "带分页、模糊查询，查询关键字：(维修资金预交查询)", response = YwpzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", grwxzjService.queryByPage(pageNum, pageSize, ywpzEntity));
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "删除按钮", notes = "", response = YwpzEntity.class)
	public R delete(@RequestBody List<YwpzEntity> list) {
		for (YwpzEntity y : list) {
			grwxzjService.deletegr(y.getDjbh());
		}

		return R.ok();
	}

	@Login
	@PostMapping("/selectfwzt")
	@ApiOperation(value = "通过房屋编码返回房屋信息的接口", notes = "", response = FwxxEntity.class)
	public R selectfwzt(@RequestBody List<String> list) {

		return R.ok().put("list", grwxzjService.selectfwzt(list));
	}

	@Login
	@PostMapping("/selectfwztbydhbm")
	@ApiOperation(value = "通过幢号编码返回房屋信息的接口", notes = "", response = FwxxEntity.class)
	public R selectfwztbydhbm(@RequestBody ZhxxEntity zhxxEntity) {

		return R.ok().put("list", grwxzjService.selectfwztbydhbm(zhxxEntity));
	}

	// @Login
	@PostMapping("/selectgrdrch")
	@ApiOperation(value = "个人预交导入通过项目名称和栋号名称查询dwbm,xmbm,dhbm", notes = "", response = YwpzEntity.class)
	public R selectxmdhdw(@RequestBody YwpzEntity ywpzEntity) {
		String dwmc = grwxzjService.selectdwbmbyxmmc(ywpzEntity);
		if ("".equals(dwmc) || dwmc == null) {
			return R.error("通过项目名称没有匹配到对应的开发单位，请检查项目名称是否正确");
		}
		String dwbm = grwxzjService.selectdwwwwbmbyxmmc(ywpzEntity);
		String xmbm = grwxzjService.selectxmbmbyxmmc(ywpzEntity);
		String dhbm = null;
		ywpzEntity.setXmbm(xmbm);
		List<ZhxxEntity> list = grwxzjService.selectdhmcbyxmbm(ywpzEntity);
		if (!list.isEmpty()) {
			for (ZhxxEntity z : list) {
				// Pattern pat = Pattern.compile(REGEX_CHINESE);
				// Matcher mat = pat.matcher(z.getDhmc());
				// String ss=mat.replaceAll("");
				// z.setDhmc(ss);
				// //通过该dhbm查寻该楼栋下所有的户主姓名并增加到判断条件中
				// List<String> xmlist=grwxzjService.selectfwbylz(z.getDhbm());
				// boolean al=false;
				// if(!xmlist.isEmpty()){
				// al=xmlist.contains(ywpzEntity.getXm());
				// }
				if (ywpzEntity.getDhmc().equals(z.getDhmc())) {
					dhbm = z.getDhbm();
				}

			}
		}
		// String dhbm = grwxzjService.selectdhbmbyxmmc(ywpzEntity);
		if ("".equals(dhbm) || dhbm == null) {
			return R.error("没有匹配到对应的楼栋信息，请检查栋号名称是否正确");
		}
		YwpzEntity y = new YwpzEntity();
		y.setDwbm(dwbm);
		y.setXmbm(xmbm);
		y.setDhbm(dhbm);
		return R.ok().put("data", y);
	}

	// @Login
	@PostMapping("/selectfwbmbyxmmj")
	@ApiOperation(value = "个人预交导入通过dhbm查询对应fwbm", notes = "", response = FwxxEntity.class)
	public R selectfwbmbyxmmj(@RequestBody FwxxEntity fwxxEntity) {
		FwxxEntity f = grwxzjService.selectfwbmbyxmmjdh(fwxxEntity);
		if (isObjectNotEmpty(f) == false) {
			return R.error("没有匹配到对应的房屋信息，请检查数据是否正确");
		}

		return R.ok().put("data", f);
	}

	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	@PostMapping("/qzw")
	@ApiOperation(value = "去掉中文", notes = "", response = FwxxEntity.class)
	public void testStr() {
		String str = "我也不知道234你不知道weqw";
		// 去除中文
		Pattern pat = Pattern.compile(REGEX_CHINESE);
		Matcher mat = pat.matcher(str);
		String ss = mat.replaceAll("");
		System.out.println(ss);
	}

	// @Login
	@PostMapping("/GRYJPLDRFWCX")
	@ApiOperation(value = "个人预交批量导入模板判断是否可以查到该房屋的脚本(已经匹配了的房屋)", notes = "", response = R.class)
	public R GRYJPLDRFWCX() {
		grwxzjService.selectgryjpldr();
		return R.ok();
	}

	// @Login
	@PostMapping("/GRYJPLDRFWCX2")
	@ApiOperation(value = "个人预交批量导入模板判断是否可以查到该房屋的脚本2(蔡甸整改好之后的个人预交数据导入用的脚本)", notes = "", response = R.class)
	public R GRYJPLDRFWCX2() {
		grwxzjService.selectgryjpldr2();
		return R.ok();
	}

	// @Login
	@PostMapping("/insertPLDR2")
	@ApiOperation(value = "个人交存页面导入按钮", notes = "个人交存将已经标记取到的fwbm批量导入业务表中并自动审核", response = YwpzEntity.class)
	public R insertPLDR2(@RequestBody List<YwpzEntity> list) {
		List<String> djbhlist = new ArrayList<String>();
		for (YwpzEntity y1 : list) {
			y1.setCbwdbm("0001");
			y1.setCzybm("7");
			y1.setCzyxm("系统");
			String djbh = grwxzjService.insertGrpldr(y1);
			try {
				// 避免批量插入高并发，主键中的时间相同，导致主键冲突，此处设置每次停顿1秒
				Thread.currentThread().sleep(1000);
			} catch (InterruptedException e) {

				e.printStackTrace();
			}
			djbhlist.add(djbh);
		}
		List<DhbmyjEntity> dhyjs = new ArrayList<DhbmyjEntity>();
		for (String djbh : djbhlist) {
			DhbmyjEntity d = new DhbmyjEntity();
			d.setDjbh(djbh);
			d.setShrbm("7");
			d.setShrxm("系统");
			dhyjs.add(d);
		}
		grwxzjfhService.updateFh(dhyjs);

		return R.ok();
	}

	// @Login
	@PostMapping("/GRLOUDIAODE")
	@ApiOperation(value = "个人补录查找漏掉的", notes = "", response = R.class)
	public R GRLOUDIAODE() {
		grwxzjService.selectloudiaode();
		return R.ok();
	}

	// @Login
	@PostMapping("/CXFWSFCFJK")
	@ApiOperation(value = "查询是否有房屋重复缴款", notes = "", response = R.class)
	public R CXFWSFCFJK() {
		List<YwpzEntity> yy = grwxzjService.CXFWSFCFJK();
		return R.ok().put("data", yy);
	}

	// @Login
	@PostMapping("/FWYZKMDY")
	@ApiOperation(value = "房屋业主科目对应", notes = "", response = R.class)
	public R FWYZKMDY() {
		grwxzjService.FWYZKMDY();
		return R.ok();
	}

	// @Login
	@PostMapping("/BJYMXG")
	@ApiOperation(value = "个人预交编辑页面修改", notes = "", response = R.class)
	public R XGZPH(@RequestBody YwpzEntity ywpzEntity) {
		grwxzjService.updategryjxx(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/checklogin")
	@ApiOperation(value = "验证登录账号是否已存在", notes = "", response = R.class)
	public R checklogin(@RequestBody SysUserEntity user) {
		SysUserEntity user1 = sysUserService.queryByLoginName(user.getLoginname());
		if (isObjectNotEmpty(user1) == true) {
			return R.error("该登录账号已存在");
		}
		return R.ok();
	}

	// @Login
	@PostMapping("/CLFWYZKMWK")
	@ApiOperation(value = "处理fwxx表中yzkm为空的房屋", notes = "", response = R.class)
	public R CLFWYZKMWK() {
		grwxzjService.updatefwyzkm();
		return R.ok();
	}

	// @Login
	@PostMapping("/updatedjrq")
	@ApiOperation(value = "个人缴款查询页面修改djrq", notes = "", response = R.class)
	public R updatedjrq(@RequestBody YwpzEntity ywpzEntity) {
		grwxzjService.updatedjrq(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/checfwsfjq")
	@ApiOperation(value = "检查房屋是否缴清呀呀", notes = "", response = R.class)
	public R checfwsfjq() {
		grwxzjService.checfwsfjq();
		return R.ok();
	}

	// @Login
	@PostMapping("/XTPLDRGRSCZS")
	@ApiOperation(value = "將已經系统批量导入的个人预交没有四舍五入刷成四舍五入", notes = "", response = R.class)
	public R XTPLDRGRSCZS() {
		grwxzjService.XTPLDRGRSCZS();
		return R.ok();
	}

	// @Login
	@PostMapping("/FZHSMXSHUA")
	@ApiOperation(value = "将已经产生的业务数据刷入辅助核算明细表中（单位）", notes = "", response = R.class)
	public R FZHSMXSHUA() {
		grwxzjService.FZHSMXSHUA();
		return R.ok();
	}

	// @Login
	@PostMapping("/FZHSMXSHUA2")
	@ApiOperation(value = "将已经产生的业务数据刷入辅助核算明细表中（个人）", notes = "", response = R.class)
	public R FZHSMXSHUA2() {
		grwxzjService.FZHSMXSHUA2();
		return R.ok();
	}

	// @Login
	@PostMapping("/FZHSYEGRDWSSSS")
	@ApiOperation(value = "将测试数据已经刷好的fzhsye中01和03月份的数据复制到正式表的01和03（将正式的01和03清空）", notes = "", response = R.class)
	public R FZHSMXSHUA22() {
		grwxzjService.FZHSMXSHUA22();
		return R.ok();
	}

	// @Login
	@PostMapping("/wcnd")
	@ApiOperation(value = "wcnd", notes = "", response = R.class)
	public R wcnd() {
		grwxzjService.wcnd();
		return R.ok();
	}

	// @Login
	@PostMapping("/my")
	@ApiOperation(value = "my", notes = "", response = R.class)
	public R my() throws NoSuchAlgorithmException {
		String encyKey = "05Xd318IsU1xoI1j ";
		KeyGenerator kgen = KeyGenerator.getInstance("AES");
		java.security.SecureRandom random = java.security.SecureRandom.getInstance("SHA1PRNG");
		random.setSeed(encyKey.getBytes());
		kgen.init(128, random);
		SecretKey secretKey = kgen.generateKey();
		byte[] enCodeFormat = secretKey.getEncoded();
		BASE64Encoder coder = new BASE64Encoder();
		System.out.println(coder.encode(enCodeFormat));
		return R.ok();
	}

	// @Login
	@PostMapping("/djbh")
	@ApiOperation(value = "djbh", notes = "找出list<String>集合中重复的元素", response = R.class)
	public R djbh() {
		grwxzjService.djbh();
		return R.ok();
	}
	
	// @Login
		@PostMapping("/yyyyy")
		@ApiOperation(value = "djbh", notes = "马来西亚", response = R.class)
		public R yyyy() {
			grwxzjService.yyyy();
			return R.ok();
		}

	// @Login
	@GetMapping("queryByPageFZHSMX")
	@ApiOperation(value = "辅助核算明细查询按钮", notes = "带分页、模糊查询，查询关键字：(维修资金查询)", response = YwpzEntity.class)
	public R queryByPageFZHSMX(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", grwxzjService.queryByPageFZHSMX(pageNum, pageSize, ywpzEntity));
	}

	// @Login
	@GetMapping("queryByPageFZHSYE")
	@ApiOperation(value = "辅助核算余额查询按钮", notes = "带分页、模糊查询，查询关键字：(维修资金查询)", response = YwpzEntity.class)
	public R queryByPageFZHSYE(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", grwxzjService.queryByPageFZHSYE(pageNum, pageSize, ywpzEntity));
	}

}
