package io.renren.modules.app.service.impl;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;

import io.renren.modules.app.dao.HomePageDao;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.HomePage_SsywblEntity;
import io.renren.modules.app.entity.JczqqsEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.HomePageService;

/**
 * 查询首页大数据展示
 *
 * @author Administrator
 */
@Service("homePageService")
public class HomePageServiceImpl extends ServiceImpl<HomePageDao, HomePage_SsywblEntity> implements HomePageService {

    /**
     * 查询实时业务办理情况
     */
    @Override
    public List<HomePage_SsywblEntity> selectSsywbl() {
        List<HomePage_SsywblEntity> list = baseMapper.selectSsywbl();
        for (int i = 0; i < list.size(); i++) {
            if ("划拨".equals(list.get(i).getDjlx())) {
                Integer sfjz = baseMapper.selectsfjz(list.get(i).getDjbh());
                if (sfjz > 0) {
                    list.get(i).setShzt("已划拨");
                } else {
                    list.get(i).setShzt("未划拨");
                }
            }
            if ("决算".equals(list.get(i).getDjlx())) {
                Integer sfjs = baseMapper.selectsfjs(list.get(i).getDjbh());
                if (sfjs > 0) {
                    list.get(i).setShzt("已决算");
                } else {
                    list.get(i).setShzt("未决算");
                }
            }
            if ("分配".equals(list.get(i).getDjlx())) {
                list.get(i).setShzt("已分配");
            }
            if ("公共收益分摊".equals(list.get(i).getDjlx())) {
                list.get(i).setShzt("已分摊");
            }
            if ("个人续补交".equals(list.get(i).getDjlx())) {
                list.get(i).setShzt("已续交");
            }
            if ("业主退款".equals(list.get(i).getDjlx())) {
                list.get(i).setShzt("已退款");
            }
            if ("业主销户".equals(list.get(i).getDjlx())) {
                list.get(i).setShzt("已销户");
            }

        }
        return list;
    }

    /**
     * 月度情况
     */
    @Override
    public Map<String, Object> ydqk() {
        Map<String, Object> map = new HashMap<String, Object>();
        // 当月个人缴纳
        String grjn = baseMapper.selectDygrjk();
        // 当月单位缴纳
        String dwjn = baseMapper.selectDydwjk();
        // 当月个人支出
        String grzc = baseMapper.selectDygrzc();

        map.put("dygrjn", grjn);
        map.put("dydwjn", dwjn);
        map.put("dygrzc", grzc);
        return map;
    }

    /**
     * 年度情况
     */
    @Override
    public Map<String, Object> ndqk() {
        Map<String, Object> map = new HashMap<String, Object>();
        // 当年个人缴纳
        String grjn = baseMapper.selectDngrjk();
        // 当年单位缴纳
        String dwjn = baseMapper.selectDndwjk();
        // 当年个人支出
        String grzc = baseMapper.selectDngrzc();

        map.put("dngrjn", grjn);
        map.put("dndwjn", dwjn);
        map.put("dngrzc", grzc);
        return map;
    }

    @Override
    public YwpzEntity selectyjxmzs() {
        // 1.先查出单位预交yjmx表中01单据的所有dhbm的集合
        List<String> z01 = baseMapper.selectdhbm01();
        // 2.在查出个人预交ywpzmx表03单据的所有dhbm的集合
        List<String> z03 = baseMapper.selectdhbm03();
        List<String> z = new ArrayList<String>();
        for (String s01 : z01) {
            z.add(s01);
        }
        for (String s03 : z03) {
            z.add(s03);
        }
        // 去重dhbm
        HashSet<String> hashSet = new HashSet<String>(z);
        Set<String> set = hashSet;
        String xmbm = null;
        List<String> xmList = new ArrayList<String>();
        for (String ss : set) {
            xmbm = baseMapper.selectxmbm(ss);
            if (!"".equals(xmbm) && xmbm != null) {
                xmList.add(xmbm);
            }
        }
        // 去重xmbm
        HashSet<String> hashSet2 = new HashSet<String>(xmList);
        Set<String> set2 = hashSet2;
        YwpzEntity y = new YwpzEntity();
        y.setYjnxmzs(set2.size());// 绑定已缴纳项目总数
        return y;
    }

    @Override
    public YwpzEntity jecx() {
        YwpzEntity y = new YwpzEntity();
        // --已缴纳金额
        YwpzEntity yyjnje = baseMapper.selectyjnje();
        y.setYjnje(yyjnje.getYjnje());
        // --已支出金额
        YwpzEntity yyzcje = baseMapper.selectyzcje();
        if(isObjectNotEmpty(yyzcje)==false){
        	y.setYzcje(0.0);
        }else{
        	y.setYzcje(yyzcje.getYzcje());	
        } 
        // --余额=已缴纳金额-已支出金额
        y.setSyye(yyjnje.getYjnje() - y.getYzcje());
        return y;
    }

    @Override
    public YwpzEntity sjqk() {
        YwpzEntity y = new YwpzEntity();
        // 单位实缴情况
        // 1.所有单位实缴金额
        YwpzEntity ysj = baseMapper.selectdwsjje();
        Double dwsjje = ysj.getSydwsjje();// 所有单位实缴金额
        // 2.所有单位应缴金额(其实就是zhxx表中所有楼栋的应缴金额)
        Double sydwyjjeSUM = 0.0;
        List<ZhxxEntity> listz = baseMapper.selelctzhxx();
        for (ZhxxEntity z : listz) {
            // 每一栋楼的应缴金额
            String jsbz = z.getJsbz();// 计算标准
            if ("0".equals(jsbz)) {// 按面积
                Double mjyjje = z.getZmj() * z.getJkbz();
                sydwyjjeSUM = sydwyjjeSUM + mjyjje;
            } else if ("1".equals(jsbz)) {// 按金额
                Double jeyjje = z.getZje() * z.getJkbz();
                sydwyjjeSUM = sydwyjjeSUM + jeyjje;
            }
        }
        // 所有单位实缴金额占比
        Double dwsjzb = dwsjje / sydwyjjeSUM;
        DecimalFormat df = new DecimalFormat("0.00%");
        String dwsjl = df.format(dwsjzb);
        y.setDwsjl(dwsjl);// 绑定单位实缴率
        // 个人实缴情况

        // 1.所有个人实缴金额
        YwpzEntity gry = baseMapper.selectgrsjje();
        Double grsjje = gry.getSygrsjje();
        // 2.所有个人应缴金额(fwxx表中所有房屋的应缴金额)
        Double sygryjjeSUM = 0.0;
        List<FwxxEntity> listfw = baseMapper.selectfwxx();
        for (FwxxEntity f : listfw) {
            String jsbz1 = f.getJsbz();// 缴款标准
            if ("0".equals(jsbz1) && !"".equals(f.getGrjjl()) && f.getGrjjl() != null) {// 按面积（新系统老系统一样）
                Double grmjyjje = f.getMj() * f.getGrjjl();
                sygryjjeSUM = sygryjjeSUM + grmjyjje;
            } else if ("2".equals(jsbz1) && !"".equals(f.getGrjjl()) && f.getGrjjl() != null) {// 按造价(老系统计算标准按造价和按面积一样算)
                Double grzjyjje = f.getMj() * f.getGrjjl();
                sygryjjeSUM = sygryjjeSUM + grzjyjje;
            } else if ("1".equals(jsbz1) && !"".equals(f.getGrjjl()) && f.getGrjjl() != null&&f.getFwje()!=null) {// 按金额(新系统计算标准和老系统一样：缴交率*fwje（总造价）,fwje=zjk)
                Double grjeyjje = f.getFwje() * f.getGrjjl();
                sygryjjeSUM = sygryjjeSUM + grjeyjje;
            }
        }
        // 所有个人实缴金额占比
        Double grsjzb = grsjje / sygryjjeSUM;
        DecimalFormat df1 = new DecimalFormat("0.00%");
        String grsjl = df1.format(grsjzb);
        y.setGrsjl(grsjl);// 绑定个人实缴率
        return y;
    }

    @Override
    public YwpzEntity jczqqs() {
        YwpzEntity y = new YwpzEntity();
        List<JczqqsEntity> jczqqslist = new ArrayList<JczqqsEntity>();
        // 1.获取当前月
        String temp_str = "";
        Date dt = new Date();
        // 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        temp_str = sdf.format(dt);//当月
        //获取当月缴存金额
        JczqqsEntity jc0 = baseMapper.selectjcje(temp_str);
        //获取当月支取金额
        JczqqsEntity zq0 = baseMapper.selectzqje(temp_str);
        JczqqsEntity b0 = new JczqqsEntity();
        if (isObjectNotEmpty(jc0) == true) {
            b0.setJiaocun(jc0.getJiaocun());
        }
        if (isObjectNotEmpty(zq0) == true) {
            b0.setZhiqu(zq0.getZhiqu());
        }
        b0.setYuefen(temp_str.substring(4, 6));
        if (isObjectNotEmpty(b0) == true) {
            jczqqslist.add(b0);
        }

        //-----------------------------------
        // 2.获取上一个月
        for (int i = 1; i < 6; i++) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");
            java.util.Date date = null;
            try {
                date = formatter.parse(temp_str);
            } catch (ParseException e) {

                e.printStackTrace();
            } // Date格式
            Calendar calBegin = Calendar.getInstance();
            // 使用给定的 Date 设置此 Calendar 的时间
            calBegin.setTime(date);
            calBegin.add(Calendar.MONTH, -i);
            String datestr = formatter.format(calBegin.getTime());// String格式//上一个月

            //获取当月缴存金额
            JczqqsEntity jc = baseMapper.selectjcje(datestr);
            //获取当月支取金额
            JczqqsEntity zq = baseMapper.selectzqje(datestr);
            JczqqsEntity b = new JczqqsEntity();
            if (isObjectNotEmpty(jc) == true) {
                b.setJiaocun(jc.getJiaocun());
            }
            if (isObjectNotEmpty(zq) == true) {
                b.setZhiqu(zq.getZhiqu());
            }
            b.setYuefen(datestr.substring(4, 6));
            if (isObjectNotEmpty(b) == true) {
                jczqqslist.add(b);
            }
        }
        y.setJczqqslist(jczqqslist);
        System.out.print(y);
        return y;
    }

    public static Boolean isObjectNotEmpty(Object obj) {
        String str = ObjectUtils.toString(obj, "");
        return StringUtils.isNotBlank(str);
    }

}
