package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.XmDao;
import io.renren.modules.app.entity.HKmEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XmEntity;
import io.renren.modules.app.entity.XmEntity2;
import io.renren.modules.app.entity.XqxxEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.XmService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service("xmService")
public class XmServiceImpl extends ServiceImpl<XmDao, XmEntity> implements XmService {

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param xmEntity
	 * @return
	 */
	@Override
	public PageInfo<XmEntity2> queryByPage(Integer pageNum, Integer pageSize, XmEntity xmEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<XmEntity2> xmEntitys = baseMapper.queryByPage(xmEntity);
		PageInfo<XmEntity2> pageInfo = new PageInfo<XmEntity2>(xmEntitys);
		return pageInfo;
	}

	/**
	 * 单个或批量删除
	 * 
	 * @param ids
	 */
	@Override
	public void deleteBatch(String[] ids) {
		this.deleteBatchIds(Arrays.asList(ids));
	}

	// 左上角小区名称下拉框数据显示
	@Override
	public List<XqxxEntity> selectxqmc() {

		return baseMapper.selectxqmcxx();
	}

	//归集，单位，小区下拉框数据展现
	@Override
	public List<XlkEntity> selectxlk(String id) {
		id=id.replace("\"", "");
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if ("01".equals(id)) {
			list = baseMapper.selectxlkgj();
		} else if ("02".equals(id)) {
			list = baseMapper.selectxlkdw();
		} else if("03".equals(id)){
			list = baseMapper.selectxlkxq();
		}else{
			
		}

		return list;
	}

	@Override
	public void insertXm(XmEntity xmEntity) {
		baseMapper.insertxm(xmEntity);
		
	}

	@Override
	public String queryxmbm() {
		
		return baseMapper.queryxmbm();
	}

	@Override
	public XmEntity maxkmbm() {
		
		return baseMapper.maxkmbm();
	}

	@Override
	public void insertkm(HKmEntity hKmEntity) {
		
		baseMapper.insertkm(hKmEntity);
	}

	@Override
	public void insertfzhsye(YwpzEntity ywpzEntity) {
		
		baseMapper.insertfzhsye(ywpzEntity);
	}

	@Override
	public void deletefzhsyexmbm(String id) {
		baseMapper.deletefzhsyexmbm(id);
		
	}

	@Override
	public String selectmaxkjqj() {
		
		return baseMapper.selectmaxkjqj();
	}

	@Override
	public String selectmaxkjqj2() {
		
		return baseMapper.selectmaxkjqj2();
	}

}