package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.GgsssyftService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 公共设施收益分摊
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/ggsssyft")
@Api(tags = "公共设施收益分摊模块(公共设施收益分摊)")
public class GgsssyftController {

	@Autowired
	private GgsssyftService ggsssyftService;

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("list", ggsssyftService.selectxlk(map));
	}

	@Login
	@GetMapping("/queryByPage")
	@ApiOperation(value = "", notes = "通过幢号编码选择楼宇查出所有房屋信息", response = FwxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,ZhxxEntity zhxxEntity) {

		return R.ok().put("data", ggsssyftService.queryByPage(pageNum, pageSize,zhxxEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "保存", notes = "")
	public R insert(@RequestBody YwpzEntity ywpzEntity) {
		ggsssyftService.insertft(ywpzEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/selectdj")
	@ApiOperation(value = "", notes = "点击单据下拉框选中某一个单据调的接口", response = YwpzEntity.class)
	public R selectdj(@RequestBody Map<String, String> map) {

		return R.ok().put("selectdj", ggsssyftService.selectdj(map));
	}

	@Login
	@PostMapping("/selectdjfw")
	@ApiOperation(value = "", notes = "点击单据下拉框选中某一个单据调的接口", response = XlkEntity.class)
	public R selectdjfw(@RequestBody Map<String, String> map) {

		return R.ok().put("selectdjfw", ggsssyftService.selectdjfw(map));
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "删除按钮", notes = "", response = YwpzEntity.class)
	public R delete(@RequestBody YwpzEntity ywpzEntity) {
		ggsssyftService.deleteft(ywpzEntity);
		return R.ok();
	}
	
	@Login
	@GetMapping("/queryByPageC")
	@ApiOperation(value = "", notes = "分页查询列表页面", response = YwpzEntity.class)
	public R queryByPageC(Integer pageNum, Integer pageSize,YwpzEntity ywpzEntity) {

		return R.ok().put("data", ggsssyftService.queryByPageC(pageNum, pageSize,ywpzEntity));
	}

}
