package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.GzdxxEntity;
import io.renren.modules.app.service.GzdxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 归集点信息
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-16 11:33:00
 */
@RestController
@RequestMapping("app/gzdxx")
@Api(tags = "归集点信息模块(归集点设置)")
public class GzdxxController {

	@Autowired
	private GzdxxService gzdxxService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = GzdxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, GzdxxEntity gzdxxEntity) {

		return R.ok().put("data", gzdxxService.queryByPage(pageNum, pageSize, gzdxxEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = GzdxxEntity.class)
	public R insert(@RequestBody GzdxxEntity gzdxxEntity) {
		gzdxxService.insert(gzdxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = GzdxxEntity.class)
	public R update(@RequestBody GzdxxEntity gzdxxEntity) {
		gzdxxService.updateById(gzdxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = GzdxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		gzdxxService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = GzdxxEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("selct", gzdxxService.selectById(id));
	}

}
