package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.HKmlbEntity;
import io.renren.modules.app.service.HKmlbService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 科目类别
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-11 09:53:01
 */
@RestController
@RequestMapping("app/hkmlb")
@Api(tags = "科目类别模块")
public class HKmlbController {

    @Autowired
    private HKmlbService hKmlbService;


    @Login
    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = HKmlbEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, HKmlbEntity hKmlbEntity) {

        return R.ok().put("data", hKmlbService.queryByPage(pageNum, pageSize, hKmlbEntity));
    }


    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = HKmlbEntity.class)
    public R insert(@RequestBody HKmlbEntity hKmlbEntity) {
            hKmlbService.insert(hKmlbEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = HKmlbEntity.class)
    public R update(@RequestBody HKmlbEntity hKmlbEntity) {
            hKmlbService.updateById(hKmlbEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = HKmlbEntity.class)
    public R delete(@RequestBody String[] ids) {
            hKmlbService.deleteBatch(ids);
        return R.ok();
    }

}
