package io.renren.modules.app.entity;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 楼盘幢号(楼宇)信息表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-21 14:25:39
 */
@Data
@TableName("zhxx")
@ApiModel(value = "楼盘幢号(楼宇)信息表")
public class LiZhxxEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("幢号编号")
    @TableId
    private String dhbm;
    @ApiModelProperty("幢号名称")
    private String dhmc;
    @ApiModelProperty("售房单位编码")
    private String dwbm;
    @ApiModelProperty("项目编码(物业)")
    private String xmbm;
    @ApiModelProperty("房屋类型")
    private String hwlx;
    @ApiModelProperty("房屋结构")
    private String hwjg;
    @ApiModelProperty("幢号")
    private String zh;
    @ApiModelProperty("户数")
    private Integer hs;
    @ApiModelProperty("层数")
    private Integer lcs;
    @ApiModelProperty("单元数")
    private Integer drs;
    @ApiModelProperty("是否电梯")
    private String sfdt;
    @ApiModelProperty("是否公有住房")
    private String sfgf;
    @ApiModelProperty("管委会编码")
    private String gwhbm;
    @ApiModelProperty("物业公司编码")
    private String wygsbm;
    @ApiModelProperty("竣工日期")
    private Date zgrq;
    @ApiModelProperty("使用年限")
    private Integer nx;
    @ApiModelProperty("总造价")
    private Double zje;
    @ApiModelProperty("总面积")
    private Double zmj;
    @ApiModelProperty("无用字段")
    private Double grze;
    @ApiModelProperty("无用字段")
    private Double dwze;
    @ApiModelProperty("单位维修基金总额(已交)")
    private Double dwyjje;
    @ApiModelProperty("个人维修基金总额(已交)")
    private Double gryjje;
    @ApiModelProperty("已售户数")
    private Integer yshs;
    @ApiModelProperty("累计支取金额")
    private Double zqje;
    @ApiModelProperty("无用字段")
    private Double dwye;
    @ApiModelProperty("余额")
    private Double dqye;
    @ApiModelProperty("单位交缴率")
    private Double jkbz;
    @ApiModelProperty("个人交缴率")
    private Double grjjl;
    @ApiModelProperty("计算标准(0按面积,1按金额)")
    private String jsbz;
    @ApiModelProperty(" 归集点编码")
    private String gzdbm;
    @ApiModelProperty("单位是否已交清")
    private String sfdz;
    @ApiModelProperty("公共收益分配")
    private Double ggsy;
    @ApiModelProperty("累计结息")
    private Double ljlx;
    @ApiModelProperty("销户金额(不含销户利息)")
    private Double xhje;
    @ApiModelProperty("销户结息")
    private Double xhjx;
    @ApiModelProperty("人防面积")
    private Double rfmj;
    @ApiModelProperty("人防面积是否有效")
    private String sfrf;
    @ApiModelProperty("架空面积")
    private Double jkmj;
    @ApiModelProperty("架空面积是否有效")
    private String sfjk;
    @ApiModelProperty("0限整,1保留1位,2保留2位")
    private String digit;
    @ApiModelProperty("")
    private String ndjx;
    @ApiModelProperty("业主科目代码")
    private String yzkm;

}
