package io.renren.modules.app.entity;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 维修基金业务表(YWPZ)
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-27 10:42:58
 */
@Data
@TableName("ywpz")
@ApiModel(value = "维修基金业务表(YWPZ)")
public class YwpzEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty("单据编号")
	@TableId
	private String djbh;
	@ApiModelProperty("单据类型")
	private String djlx;
	@ApiModelProperty("单据日期")
	private String djrq;
	@ApiModelProperty("售房单位编码")
	private String dwbm;
	@ApiModelProperty("承办网点编码")
	private String cbwdbm;
	@ApiModelProperty("银行编码")
	private String bankCode;
	@ApiModelProperty("归集点编码")
	private String gzdbm;
	@ApiModelProperty("结算号")
	private String zph;
	@ApiModelProperty("结算号")
	private String zph2;
	@ApiModelProperty("交款金额")
	private Double je;
	@ApiModelProperty("操作员编码")
	private String czybm;
	@ApiModelProperty("操作员姓名")
	private String czyxm;
	@ApiModelProperty("备注")
	private String bz;
	@ApiModelProperty("凭证字")
	private String pzz;
	@ApiModelProperty("凭证号")
	private String pzh;
	@ApiModelProperty("分录序号")
	private Integer flsh;
	@ApiModelProperty("结算方式")
	private String jsfs;
	@ApiModelProperty("会计期间")
	private String kjqj;
	@ApiModelProperty("收益项目")
	private String syxm;
	@ApiModelProperty("幢号编码")
	private String dhbm;
	@ApiModelProperty("分摊方式")
	private String fpfs;
	@ApiModelProperty("分摊方式")
	private String fpfs2;
	@ApiModelProperty("业务凭证状态0未审核1已审核2审核冲帐3冲账")
	private String pzzt;
	@ApiModelProperty("")
	private String xgbm;
	@ApiModelProperty("")
	private String jkfx;
	@ApiModelProperty("审核人编码")
	private String shrbm;
	@ApiModelProperty("审核人姓名")
	private String shrxm;
	@ApiModelProperty("审核日期")
	private String shrq;
	@ApiModelProperty("审核状态")
	private String shzt;
	@ApiModelProperty("产权证号")
	private String cczh;

	// 维修资金分配查询
	@ApiModelProperty("单位名称")
	private String dwmc;
	@ApiModelProperty("项目名称")
	private String xmmc;
	@ApiModelProperty("幢号名称")
	private String dhmc;
	@ApiModelProperty("分摊金额(预交金额)")
	private Double yjje;
	@ApiModelProperty("项目編碼")
	private String xmbm;

	// // 房屋信息需要的
	// private String cczh;
	@ApiModelProperty("房屋编码(原主键)")
	private String fwbm;
	@ApiModelProperty("门牌号码")
	private String mphm;
	@ApiModelProperty("户主姓名")
	private String xm;
	@ApiModelProperty("证件号")
	private String sfzh;

	@ApiModelProperty("")
	private String lxdh;

	@ApiModelProperty("房屋总价")
	private Double fwje;
	@ApiModelProperty("楼层")
	private Integer lc;

	@ApiModelProperty("房屋性质")
	private String fwxz;
	@ApiModelProperty("购房日期")
	private String gfrq;

	@ApiModelProperty("购房发票号")
	private String fpbh;
	@ApiModelProperty("售房单价")
	private Double ssdj;

	@ApiModelProperty("")
	private String hx;

	// 维修资金预交新增保存按钮
	@ApiModelProperty("本次实缴金额(实缴金额)")
	private Double yjsjje;
	@ApiModelProperty("批量预交")
	private List<String> dhbmlist;
	@ApiModelProperty("预交实缴金额集合")
	private List<Double> yjsjjelist;
	@ApiModelProperty("预交明细编码")
	private String yjmxbm;

	// 单位复核查看按钮所需
	@ApiModelProperty("结算方式")
	private String billname;
	@ApiModelProperty("银行名称")
	private String yhmc;
	@ApiModelProperty("总造价")
	private Double zje;
	@ApiModelProperty("总面积")
	private Double zmj;
	@ApiModelProperty("单位维修基金总额(已交)")
	private Double dwyjje;
	@ApiModelProperty("个人维修基金总额(已交)")
	private Double gryjje;
	@ApiModelProperty("单位交缴率")
	private Double jkbz;
	@ApiModelProperty("计算标准(0按面积,1按金额)")
	private String jsbz;

	@ApiModelProperty("房屋结构")
	private String hwjg;

	// wxjjyj表
	@ApiModelProperty("预交编码")
	private String yjbm;
	@ApiModelProperty("预交幢号编码")
	private String yjdhbm;
	@ApiModelProperty("预交欠缴金额")
	private Double yjqjje;
	@ApiModelProperty("预交已交金额")
	private Double yjyjje;
	@ApiModelProperty("预交日期")
	private String yjrq;

	@ApiModelProperty("批量预交")
	private List<DhbmyjEntity> listdhandsj;

	@ApiModelProperty("个人预交缴款金额")
	private Double bjje;
	@ApiModelProperty("房屋地址")
	private String dz;
	@ApiModelProperty("收益项目编码")
	private String zdbm;
	@ApiModelProperty("小区名称")
	private String xqmc;
	@ApiModelProperty("收益项目名称")
	private String zdmc;

	@ApiModelProperty("收益总额")
	private Double syze;
	@ApiModelProperty("是否已分配")
	private String sffp;
	@ApiModelProperty("收益项目类型")
	private String lx;
	@ApiModelProperty("开始单据日期")
	private String beginrq;
	@ApiModelProperty("结束单据日期")
	private String endrq;
	@ApiModelProperty("开始审核日期")
	private String beginshrq;
	@ApiModelProperty("结束审核日期")
	private String endshrq;
	@ApiModelProperty("物业公司编码")
	private String wygsbm;
	@ApiModelProperty("小区编码")
	private String xqbm;
	@ApiModelProperty("物业公司编码")
	private String wygsid;
	@ApiModelProperty("物业公司名称")
	private String wygsmc;

	@ApiModelProperty("支取金额也是审批金额(存入ywpz表je中为划拨金额)")
	private Double spje;
	@ApiModelProperty("申请单编号")
	private String sqdbh;
	@ApiModelProperty("决算单编号")
	private String jsdbh;
	@ApiModelProperty("分摊明细")
	private List<FwxxEntity> ftmx;

	@ApiModelProperty("个人缴交率")
	private Double grjjl;
	@ApiModelProperty("房屋面积")
	private Double mj;
	@ApiModelProperty("决算金额")
	private Double jsje;
	@ApiModelProperty("决算人")
	private String jsr;
	@ApiModelProperty("决算人编码")
	private String jsrbm;
	@ApiModelProperty("决算日期")
	private String jsrq;
	@ApiModelProperty("结算银行")
	private String jsyh;
	@ApiModelProperty("结算方式")
	private String jsfshi;
	@ApiModelProperty("结算号")
	private String jsh;
	@ApiModelProperty("结算备注")
	private String jsbzhu;
	@ApiModelProperty("销户金额")
	private Double grje;
	@ApiModelProperty("销户结息")
	private Double xhjx;
	@ApiModelProperty("是否售出")
	private String sfsc;
	@ApiModelProperty("总金额")
	private Double sumje;
	@ApiModelProperty("最大编号")
	private String maxbh;

	@ApiModelProperty("银行科目代码")
	private String yhkmdm;

	@ApiModelProperty("银行科目名称")
	private String yhkmmc;

	@ApiModelProperty("开发商科目代码")
	private String kfskmdm;

	@ApiModelProperty("业主科目代码")
	private String yzkmdm;

	@ApiModelProperty("业主科目代码名称")
	private String yzkmdmmc;

	@ApiModelProperty("开发商科目代码名称")
	private String kfskmdmmc;

	@ApiModelProperty("制单人名称")
	private String zdrmc;
	@ApiModelProperty("制单人编码")
	private String zdrbm;

	@ApiModelProperty("是否合并分录")
	private int sfhbfl;
	@ApiModelProperty("是否合并分录")
	private List<HPzEntity> hPzEntities;

	@ApiModelProperty("银行科目编码")
	private String yhdm;

	@ApiModelProperty("附件张数")
	private Integer fjzs;

	@ApiModelProperty("凭证日期")
	private String pzrq;
	@ApiModelProperty("结算日期")
	private String pjrq;

	@ApiModelProperty("销户金额")
	private Double zckje;

	@ApiModelProperty("单位支取金额")
	private Double dwzqje;

	@ApiModelProperty("业主支取金额")
	private Double yzzqje;

	@ApiModelProperty("")
	private String hsqjbm;

	@ApiModelProperty("大写金额")
	private String jedx;

	@ApiModelProperty("楼幢总面积")
	private Double lzzmj;

	@ApiModelProperty("已缴纳项目总数")
	private Integer yjnxmzs;

	@ApiModelProperty("已缴纳金额")
	private Double yjnje;

	@ApiModelProperty("已支出金额")
	private Double yzcje;

	@ApiModelProperty("已缴纳-已支出的金额")
	private Double syye;

	@ApiModelProperty("所有单位实缴金额")
	private Double sydwsjje;

	@ApiModelProperty("所有个人实缴金额")
	private Double sygrsjje;

	@ApiModelProperty("所有单位实缴率")
	private String dwsjl;

	@ApiModelProperty("所有个人实缴率")
	private String grsjl;

	@ApiModelProperty("缴存支取趋势集合")
	private List<JczqqsEntity> jczqqslist;

	@ApiModelProperty("归集维修资金平衡检查")
	private String gjphjc;

	@ApiModelProperty("科目代码")
	private String km;

	@ApiModelProperty("预提科目代码")
	private String ytkm;

	@ApiModelProperty("业务支出科目代码")
	private String ywzckm;

	@ApiModelProperty("利息和")
	private Double sumlx;

	@ApiModelProperty("结息年度")
	private String jxnd;

	@ApiModelProperty("预提利息对象")
	private HYtlxbEntity hYtlxbEntity;

	@ApiModelProperty("冲缴存金额")
	private Double ncje;

	@ApiModelProperty("支取处理金额")
	private Double nzje;

	@ApiModelProperty("所选结息楼幢")
	private List<ZhxxEntity> zhlist;

	@ApiModelProperty("是否是系统批量录入（0否，1是）")
	private String sfsxtpl;

	@ApiModelProperty("批量导入最大业务日期")
	private String maxywrq;

	@ApiModelProperty("")
	private String sfyj;

	@ApiModelProperty("账套编码")
	private String ztbm;

	@ApiModelProperty("是否特殊生成（0-否，1-是；开放商代缴，post方式的个人单据都要特殊生成；即勾选的是同一天同一银行，票据号相同或同一天，同一银行，结算方式都为post机方式）")
	private String sftssc;

	@ApiModelProperty("个人凭证下方所有金额合计")
	private Double jezh;

	@ApiModelProperty("操作日期（用来查是否是补录的）")
	private String czrq;

	@ApiModelProperty("开发商代缴编码")
	private String djbm;

	@ApiModelProperty("摘要名称")
	private String zymc;

	@ApiModelProperty("辅助类别（交存-01，结息-02，使用-03，退款-04）")
	private String fzlb;

	@ApiModelProperty("辅助科目类别，开发商-D，业主-Y")
	private String fzkmlb;

	@ApiModelProperty("辅助类别专用")
	private String djlx2;

	@ApiModelProperty("归集会计期间")
	private String gjkjqj;

	@ApiModelProperty("财务会计期间")
	private String cwkjqj;

	@ApiModelProperty("手机号")
	private String sjh;

	@ApiModelProperty("借方发生额")
	private Double jffse;

	@ApiModelProperty("贷方发生额")
	private Double dffse;

	@ApiModelProperty("模糊搜索")
	private String mhlook;

	@ApiModelProperty("期初余额")
	private Double qcye;

	@ApiModelProperty("期末余额")
	private Double qmye;

	@ApiModelProperty("贷方摘要特殊字段")
	private String dfzytszd;

	@ApiModelProperty("")
	private String billcode;

	@ApiModelProperty("申请日期")
	private String sqrq;

	@ApiModelProperty("分摊人编码")
	private String fprbm;
	@ApiModelProperty("分摊人姓名")
	private String fprxm;
	@ApiModelProperty("分摊日期（没用）")
	private String fprq;

	@ApiModelProperty("维修单状态（1.已申请，2.已审核，3.首次拨付，4.余额拨付）")
	private String wxdzt;
	
	@ApiModelProperty("结算金额")
	private Double jiesuanje;
	
	@ApiModelProperty("余额拨付金额")
	private Double yebfje;
	
	@ApiModelProperty("维修部位")
	private String wxbw;
	
	@ApiModelProperty("辅助类别支取专用")
	private String djlx3;
	
	@ApiModelProperty("")
	private String zqlx;
	
	@ApiModelProperty("第三方审价费用")
	private Double dsfsjfy;
	
	@ApiModelProperty("工程余额拨付金额")
	private Double gcyebfje;
	
	@ApiModelProperty("")
	private String bm;
	
	@ApiModelProperty("")
	private Double bys;
	
	@ApiModelProperty("")
	private Double bnljs;
	
	@ApiModelProperty("")
	private Double spzzwxzj;
	
	@ApiModelProperty("")
	private Double ysgyzfwxzj;
	
	@ApiModelProperty("")
	private Double dfpljsy;
	
	@ApiModelProperty("")
	private Double jzchj;
	
	@ApiModelProperty("")
    private Double dwje;
    
    @ApiModelProperty("")
    private Double qdwje;
    
    @ApiModelProperty("")
    private Double qgrje;
    
    @ApiModelProperty("")
    private Double hdwje;
    
    @ApiModelProperty("")
    private Double hgrje;
    
    @ApiModelProperty("")
    private String ywbh;
    
    @ApiModelProperty("")
    private Double dfje;
    
    @ApiModelProperty("")
    private Double ywje;
    
    @ApiModelProperty("")
    private Double cwje;
    
    @ApiModelProperty("")
    private Double ce;
}
