package io.renren.modules.app.service.impl;

import com.alibaba.druid.sql.ast.statement.SQLIfStatement.Else;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.WxzjyjdrDao;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.HGryjxEntity;
import io.renren.modules.app.entity.HKmEntity;
import io.renren.modules.app.entity.HKmyeEntity;
import io.renren.modules.app.entity.HPzEntity;
import io.renren.modules.app.entity.JieXiEntity;
import io.renren.modules.app.entity.LlbEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XtcsEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzmxEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.WxzjyjdrService;

import java.math.BigDecimal;
import java.text.DateFormat;
//import sun.util.calendar.BaseCalendar.Date;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

@Service("wxzjyjdrService")
public class WxzjyjdrServiceImpl extends ServiceImpl<WxzjyjdrDao, YwpzEntity> implements WxzjyjdrService {

	@Override
	public List<XlkEntity> selectxlk(String id) {
		id = id.replace("\"", "");
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if ("01".equals(id)) {
			list = baseMapper.selectdw();
		} else if ("02".equals(id)) {
			list = baseMapper.selectyh();
		} else {
			list = baseMapper.selectjsfs();
		}
		return list;
	}

	@Override
	public void insertBc(YwpzEntity ywpzEntity) {
		baseMapper.insertbc(ywpzEntity);

	}

	@Override
	public int selectgzd(String id) {

		return baseMapper.selectgzd(id);
	}

	@Override
	public int selectxtcs(String id) {

		return baseMapper.selectxtcs(id);
	}

	@Override
	public int selectkjqj(String id) {

		return baseMapper.selectdqkjqj(id);
	}

	@Override
	public int selecthsqj(YwpzEntity ywpzEntity) {

		return baseMapper.selecthsqj(ywpzEntity);
	}

	@Override
	public String selectsfyj(YwpzEntity ywpzEntity) {

		return baseMapper.selectsfyj(ywpzEntity);
	}

	@Override
	public int selectdwjk(YwpzEntity ywpzEntity) {

		return baseMapper.selectdwjk(ywpzEntity);
	}

	@Override
	public int selectgrjk(YwpzEntity ywpzEntity) {

		return baseMapper.selectgrjk(ywpzEntity);
	}

	@Override
	public List<YwpzEntity> selectwftphjc(YwpzEntity ywpzEntity) {

		return baseMapper.selectwftphjc(ywpzEntity);
	}

	@Override
	public List<YwpzEntity> selectyftphjc(YwpzEntity ywpzEntity) {

		return baseMapper.selectyftphjc(ywpzEntity);
	}

	@Override
	public List<YwpzEntity> selectgrwxzjphjc(YwpzEntity ywpzEntity) {

		return baseMapper.selectgrwxzjphjc(ywpzEntity);
	}

	public void h_kmye(YwpzEntity ywpzEntity) {// 刷每个会计期间jfje，dfje,ljjfje,ljdfje。
		List<HKmyeEntity> l1 = baseMapper.selectpzfse(ywpzEntity);// 从凭证表获取某一会计期间每个科目的贷方总额，借方总额。
		// 判断该会计期间凭证科目在科目余额表中是否不存在该科目，如果科目余额表中没有该会计期间的凭证对应的科目，则向科目余额表中新增该科目。
		for (int j = 0; j < l1.size(); j++) {
			int count = baseMapper.selectkmsfcz(l1.get(j));
			if (count == 0) {
				// 月结2018-12到2019-01，要在这里判断当前kjqj是否>2018-12，如果大于，ztbm=0002
				String kjqj = l1.get(j).getKjqj();
				String gdrq = "2018-12";// 切换新旧科目的临界日期
				int res = kjqj.compareTo(gdrq);
				l1.get(j).setZtbm("0003");
				baseMapper.insertnewkm(l1.get(j));
			}
		}
		List<HKmyeEntity> l2 = baseMapper.selectpzfse2(ywpzEntity);// 从科目余额表中查某会计期间所有的科目余额发生额。
		for (int i = 0; i < l1.size(); i++) {
			for (int j = 0; j < l2.size(); j++) {
				if (l1.get(i).getHskmdm().equals(l2.get(j).getHskmdm())) {
					Double a = l1.get(i).getDfje();
					Double b = l1.get(i).getJfje();
					l2.get(j).setDfje(l1.get(i).getDfje());
					l2.get(j).setJfje(l1.get(i).getJfje());
					Double c = l2.get(j).getLjjfje();
					Double d = l2.get(j).getLjdfje();

					Double e = a + d;
					Double f = b + c;
					l2.get(j).setLjjfje(f);
					l2.get(j).setLjdfje(e);
					l2.get(j).setKjqj(ywpzEntity.getKjqj());
					baseMapper.updatekmye2(l2.get(j));
				}
			}
		}
	}

	public void h_kmye2(YwpzEntity ywpzEntity) {// 生成下一个月余额得期初余额数据。
		List<HKmyeEntity> l = baseMapper.selectpzfse2(ywpzEntity);// 从科目余额表中查某会计期间所有的科目余额发生额。
		for (int i = 0; i < l.size(); i++) {
			String kjqj = l.get(i).getKjqj();
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			java.util.Date date = null;
			try {
				date = formatter.parse(kjqj);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin.setTime(date);
			calBegin.add(Calendar.MONTH, 1);
			String datestr = formatter.format(calBegin.getTime());// String格式

			l.get(i).setKjqj(datestr);
			if ("0".equals(l.get(i).getKmsx())) {
				l.get(i).setQcye(l.get(i).getQcye() + l.get(i).getJfje() - l.get(i).getDfje());
			} else if ("1".equals(l.get(i).getKmsx())) {
				l.get(i).setQcye(l.get(i).getQcye() - l.get(i).getJfje() + l.get(i).getDfje());
			}

			l.get(i).setJfje(0.0);
			l.get(i).setDfje(0.0);
			baseMapper.updatekmye(l.get(i));
		}
	}

	public void h_kmye3(YwpzEntity ywpzEntity) {// 生成下一个月余额得期初余额数据。
		List<HKmyeEntity> l = baseMapper.selectpzfse2(ywpzEntity);// 从科目余额表中查某会计期间所有的科目余额发生额。
		for (int i = 0; i < l.size(); i++) {
			String kjqj = l.get(i).getKjqj();
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			java.util.Date date = null;
			try {
				date = formatter.parse(kjqj);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin.setTime(date);
			calBegin.add(Calendar.MONTH, 1);
			String datestr = formatter.format(calBegin.getTime());// String格式
			l.get(i).setKjqj(datestr);
			if ("0".equals(l.get(i).getKmsx())) {
				l.get(i).setQcye(l.get(i).getQcye() + l.get(i).getJfje() - l.get(i).getDfje());
			} else if ("1".equals(l.get(i).getKmsx())) {
				l.get(i).setQcye(l.get(i).getQcye() - l.get(i).getJfje() + l.get(i).getDfje());
			}
			l.get(i).setJfje(0.0);
			l.get(i).setDfje(0.0);
			baseMapper.updatekmye3(l.get(i));
		}
	}

	@Override
	public void updatextcs(YwpzEntity ywpzEntity) {

		baseMapper.updatextcs(ywpzEntity);
	}

	@Override
	public void updatehsqj(YwpzEntity ywpzEntity) {

		baseMapper.updatehsqj(ywpzEntity);

	}

	@Override
	public String selectcwsfyj(YwpzEntity ywpzEntity) {

		return baseMapper.selectcwsfyj(ywpzEntity);
	}

	@Override
	public String selectscwsfyj(YwpzEntity ywpzEntity) {
		String kjqj = ywpzEntity.getKjqj();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
		java.util.Date date = null;
		try {
			date = formatter.parse(kjqj);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // Date格式
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(date);
		calBegin.add(Calendar.MONTH, -1);
		String datestr = formatter.format(calBegin.getTime());// String格式

		return baseMapper.selectscwsfyj(datestr);
	}

	@Override
	public List<HPzEntity> selectpzjz(YwpzEntity ywpzEntity) {

		return baseMapper.selectpzjz(ywpzEntity);
	}

	@Override
	public void updatecwhsqj(YwpzEntity ywpzEntity) {
		baseMapper.updatecwhsqj(ywpzEntity);

	}

	@Override
	public void updatehzt(YwpzEntity ywpzEntity) {

		baseMapper.updatehzt(ywpzEntity);
	}

	@Override
	public int selectcwkjqj(String id) {

		return baseMapper.selectcwkjqj(id);
	}

	@Override
	public void updatefyjhsqj(YwpzEntity ywpzEntity) {

		baseMapper.updatefyjhsqj(ywpzEntity);

	}

	@Override
	public void deleteqcye(YwpzEntity ywpzEntity) {

		baseMapper.deleteqcye(ywpzEntity);
	}

	@Override
	public void updatefse(YwpzEntity ywpzEntity) {
		List<HKmyeEntity> list = baseMapper.selectkmye(ywpzEntity);
		for (HKmyeEntity k : list) {
			k.setLjdfje(k.getLjdfje() - k.getDfje());
			k.setLjjfje(k.getLjjfje() - k.getJfje());
			if ("400101".equals(k.getHskmdm())) {
				k.setDfje(0.0);
			} else if ("5001".equals(k.getHskmdm())) {
				k.setJfje(0.0);
			} else if ("5101".equals(k.getHskmdm())) {
				k.setJfje(0.0);
			}else if ("300101".equals(k.getHskmdm())) {
				
			}else if ("300102".equals(k.getHskmdm())) {
				
			} else {
				k.setDfje(0.0);
				k.setJfje(0.0);
			}
			baseMapper.updatefse(k);
		}

	}

	@Override
	public void updatecwfhsqj(YwpzEntity ywpzEntity) {

		baseMapper.updatecwfhsqj(ywpzEntity);

	}

	@Override
	public void kmqiquan() {
		// 查询科目表中所有的科目。
		List<HKmEntity> listkm = baseMapper.selecthkm();
		// 查询某个个时间段
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		java.util.Date dBegin = null;
		try {
			dBegin = sdf.parse("2009-01");
		} catch (ParseException e1) {
			e1.printStackTrace();
		}
		java.util.Date dEnd = null;
		try {
			dEnd = sdf.parse("2010-01");
		} catch (ParseException e) {
			e.printStackTrace();
		}
		List<String> datas = findDates(dBegin, dEnd);
		System.out.print("ddd");
		// 判断科目表中的每一个科目是否在科目余额表每个会计期间中存在，若不存在，则新增进去。
		for (String kjqj : datas) {
			// 查询h_kmye表中每个kjqj中的km
			List<HKmyeEntity> listkmye = baseMapper.selelctkmyeo(kjqj);
			List<String> kmye = new ArrayList<>();
			for (HKmyeEntity ye : listkmye) {
				kmye.add(ye.getHskmdm());
			}
			for (HKmEntity km : listkm) {
				boolean a = kmye.contains(km.getKm());// 判断km表中的每一个科目在每个会计期间中是否存在，如果不存在，则新增该km
				if (a == false) {
					HKmyeEntity y = new HKmyeEntity();
					y.setHskmdm(km.getKm());
					y.setKjqj(kjqj);
					y.setZtbm("0001");
					baseMapper.insertnewkm(y);
				}

			}
		}
	}

	public List<String> findDates(java.util.Date dBegin, java.util.Date dEnd) {
		List<String> lDate = new ArrayList<String>();
		SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM");
		lDate.add(sd.format(dBegin));
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(dBegin);
		Calendar calEnd = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calEnd.setTime(dEnd);
		// 测试此日期是否在指定日期之后
		while (dEnd.after(calBegin.getTime())) {
			// 根据日历的规则，为给定的日历字段添加或减去指定的时间量
			calBegin.add(Calendar.MONTH, 1);
			lDate.add(sd.format(calBegin.getTime()));
		}
		return lDate;
	}

	@Override
	public void inserthhsqj(String id) {

		baseMapper.inserthhsqj(id);
	}

	@Override
	public void deletehsqj(String id) {

		baseMapper.deletehsqj(id);
	}

	@Override
	public String selectsysfyj(YwpzEntity ywpzEntity) {
		String kjqj = ywpzEntity.getKjqj();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
		java.util.Date date = null;
		try {
			date = formatter.parse(kjqj);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // Date格式
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(date);
		calBegin.add(Calendar.MONTH, -1);
		String datestr = formatter.format(calBegin.getTime());// String格式
		ywpzEntity.setKjqj(datestr);

		return baseMapper.selectsysfyj(ywpzEntity);
	}

	@Override
	public int selectywlcmzw(YwpzEntity ywpzEntity) {

		return baseMapper.selectywlcmzw(ywpzEntity);
	}

	@Override
	public int selectzqmzw(YwpzEntity ywpzEntity) {

		return baseMapper.selectzqmzw(ywpzEntity);
	}

	@Override
	public void insertcwhsqj(String id) {
		String a = baseMapper.queryhsqjbm();
		String c = Integer.toString(Integer.parseInt(a) + 1);
		String hsqjbm = c;
		YwpzEntity y = new YwpzEntity();
		y.setKjqj(id);
		y.setHsqjbm(hsqjbm);
		baseMapper.insertcwhsqj(y);
	}

	@Override
	public void deletecwhsqj(String id) {

		baseMapper.deletecwhsqj(id);
	}

	@Override
	public List<HPzEntity> selectCWSSPH(HPzEntity hPzEntity) {
		List<HPzEntity> list = baseMapper.selectCWSSPH(hPzEntity);// 查询全部级别号的科目数据
		Double sumzjqcye102 = 0.0;
		Double sumzdqcye102 = 0.0;
		Double sumzjfje102 = 0.0;
		Double sumzdfje102 = 0.0;
		Double sumjqmye102 = 0.0;
		Double sumdqmye102 = 0.0;

		Double sumzjqcye211 = 0.0;
		Double sumzdqcye211 = 0.0;
		Double sumzjfje211 = 0.0;
		Double sumzdfje211 = 0.0;
		Double sumjqmye211 = 0.0;
		Double sumdqmye211 = 0.0;

		for (int i = 0; i < list.size(); i++) {// 计算级别号为2的科目的值
			if (list.get(i).getKmdm().length() == 6 && !"110001".equals(list.get(i).getKmdm())
					&& !"207001".equals(list.get(i).getKmdm())) {
				list.get(i).setZjqcye(list.get(i + 1).getZjqcye() + list.get(i + 2).getZjqcye());
				list.get(i).setZdqcye(list.get(i + 1).getZdqcye() + list.get(i + 2).getZdqcye());
				list.get(i).setZjfje(list.get(i + 1).getZjfje() + list.get(i + 2).getZjfje());
				list.get(i).setZdfje(list.get(i + 1).getZdfje() + list.get(i + 2).getZdfje());
				list.get(i).setJqmye(list.get(i + 1).getJqmye() + list.get(i + 2).getJqmye());
				list.get(i).setDqmye(list.get(i + 1).getDqmye() + list.get(i + 2).getDqmye());
			} else if ("102".equals(list.get(i).getKmdm().substring(0, 3)) && list.get(i).getKmdm().length() == 9) {// 累加102的最低级科目的金额之和
				sumzjqcye102 = sumzjqcye102 + list.get(i).getZjqcye();
				sumzdqcye102 = sumzdqcye102 + list.get(i).getZdqcye();
				sumzjfje102 = sumzjfje102 + list.get(i).getZjfje();
				sumzdfje102 = sumzdfje102 + list.get(i).getZdfje();
				sumjqmye102 = sumjqmye102 + list.get(i).getJqmye();
				sumdqmye102 = sumdqmye102 + list.get(i).getDqmye();
			} else if ("211".equals(list.get(i).getKmdm().substring(0, 3)) && list.get(i).getKmdm().length() == 9) {// 累加211的最低级科目的金额之和
				sumzjqcye211 = sumzjqcye211 + list.get(i).getZjqcye();
				sumzdqcye211 = sumzdqcye211 + list.get(i).getZdqcye();
				sumzjfje211 = sumzjfje211 + list.get(i).getZjfje();
				sumzdfje211 = sumzdfje211 + list.get(i).getZdfje();
				sumjqmye211 = sumjqmye211 + list.get(i).getJqmye();
				sumdqmye211 = sumdqmye211 + list.get(i).getDqmye();
			}
		}

		for (int j = 0; j < list.size(); j++) {
			if ("102".equals(list.get(j).getKmdm())) {// 计算102的科目金额和
				list.get(j).setZjqcye(sumzjqcye102);
				list.get(j).setZdqcye(sumzdqcye102);
				list.get(j).setZjfje(sumzjfje102);
				list.get(j).setZdfje(sumzdfje102);
				list.get(j).setJqmye(sumjqmye102);
				list.get(j).setDqmye(sumdqmye102);
			} else if ("211".equals(list.get(j).getKmdm())) {// 计算211的科目金额和
				list.get(j).setZjqcye(sumzjqcye211);
				list.get(j).setZdqcye(sumzdqcye211);
				list.get(j).setZjfje(sumzjfje211);
				list.get(j).setZdfje(sumzdfje211);
				list.get(j).setJqmye(sumjqmye211);
				list.get(j).setDqmye(sumdqmye211);
			} else if ("110".equals(list.get(j).getKmdm())) {// 计算110的科目金额和
				list.get(j).setZjqcye(list.get(j + 1).getZjqcye());
				list.get(j).setZdqcye(list.get(j + 1).getZdqcye());
				list.get(j).setZjfje(list.get(j + 1).getZjfje());
				list.get(j).setZdfje(list.get(j + 1).getZdfje());
				list.get(j).setJqmye(list.get(j + 1).getJqmye());
				list.get(j).setDqmye(list.get(j + 1).getDqmye());
			} else if ("207".equals(list.get(j).getKmdm())) {// 计算207的科目金额和
				list.get(j).setZjqcye(list.get(j + 1).getZjqcye());
				list.get(j).setZdqcye(list.get(j + 1).getZdqcye());
				list.get(j).setZjfje(list.get(j + 1).getZjfje());
				list.get(j).setZdfje(list.get(j + 1).getZdfje());
				list.get(j).setJqmye(list.get(j + 1).getJqmye());
				list.get(j).setDqmye(list.get(j + 1).getDqmye());
			}
		}
		if (hPzEntity.getJbh() == 1) {// 查级别号为一级的
			Iterator<HPzEntity> it = list.iterator();
			while (it.hasNext()) {
				HPzEntity x = it.next();
				if (x.getJbh() != 1) {
					it.remove();
				}
			}

		} else if (hPzEntity.getJbh() == 0) {// 查全部

		} else if (hPzEntity.getJbh() == 2) {// 查级别号为二级的
			Iterator<HPzEntity> it = list.iterator();
			while (it.hasNext()) {
				HPzEntity x = it.next();
				if (x.getJbh() != 2) {
					it.remove();
				}
			}
		} else {// 查级别号为三级的
			Iterator<HPzEntity> it = list.iterator();
			while (it.hasNext()) {
				HPzEntity x = it.next();
				if (x.getJbh() != 3) {
					it.remove();
				}
			}
		}
		return list;
	}

	@Override
	public List<ZhxxEntity> selectzhxx() {

		return baseMapper.selectzhxx();
	}

	@Override
	public XtcsEntity selectxtcs() {

		return baseMapper.selectxtcs1();
	}

	@Override
	public int selectndsj() {

		return baseMapper.selectndsj();
	}

	@Override
	public YwpzEntity selectkjnd() {

		return baseMapper.selectkjnd();
	}

	@Override
	public List<FwxxEntity> selectfwxxbydh(String id) {

		return baseMapper.selectfwxxbydh(id);
	}

	@Override
	public HPzEntity selectgjlastday(String id) {

		return baseMapper.selectgjlastday(id);
	}

	@Override
	public String selectjxmaxbh(String id) {
		// 获取单据编号
		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(id);
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "10" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "10" + temp_str1 + result;
		}

		return newdjbh;
	}

	@Override
	public List<LlbEntity> selectllxx(HashMap<String, String> map) {

		return baseMapper.selectllxx(map);
	}

	@Override
	public HashMap<String, String> selectndrq(String vrq) {// 11.获取年度日期(传参：vrq;返回参数：所在年度，年度开始日期，年度终止日期)
		DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
		Date dt = new Date();
		String dqrq = vrq;
		String begtime = null;
		String endtime = null;
		String nd = null;

		// 默认按xtcs表中lxlx值为1来处理（1则按每年7月01号到次年6月30号；不为1时则按每年01-01到当年12月31号）
		try {
			if (sdf.parse(dqrq).getTime() >= sdf.parse(dqrq.substring(0, 4) + "-07-01").getTime()) {
				begtime = dqrq.substring(0, 4) + "-07-01";// 年度开始日期
				java.util.Date date = null;
				try {
					date = formatter.parse(begtime);
				} catch (ParseException e) {
					e.printStackTrace();
				} // Date格式
				Calendar calBegin = Calendar.getInstance();
				// 使用给定的 Date 设置此 Calendar 的时间
				calBegin.setTime(date);
				calBegin.add(Calendar.YEAR, 1);
				String datestr = formatter.format(calBegin.getTime());// String格式
				endtime = datestr.substring(0, 4) + "-06-30";// 年底终止日期
				nd = datestr.substring(0, 4);// 所在年度
			} else {
				endtime = dqrq.substring(0, 4) + "-06-30";// 年底终止日期
				nd = dqrq.substring(0, 4);// 所在年度
				java.util.Date date = null;
				try {
					date = formatter.parse(endtime);
				} catch (ParseException e) {
					e.printStackTrace();
				} // Date格式
				Calendar calBegin = Calendar.getInstance();
				// 使用给定的 Date 设置此 Calendar 的时间
				calBegin.setTime(date);
				calBegin.add(Calendar.YEAR, -1);
				String datestr = formatter.format(calBegin.getTime());// String格式
				begtime = datestr.substring(0, 4) + "-07-01";// 年度开始日期
			}

		} catch (ParseException e) {
			e.printStackTrace();
		}

		HashMap<String, String> map = new HashMap<String, String>();
		map.put("begtime", begtime);
		map.put("endtime", endtime);
		map.put("nd", nd);
		return map;
	}

	@Override
	public List<JieXiEntity> slelectllxx(HashMap<String, String> map, List<LlbEntity> lllist) {// 获取利率信息方法(传参：上面返回的年度开始日期，年度终止日期；返回的参数：参数为2的定期利率集合参数，参数为1的活期利率集合参数)
		List<JieXiEntity> hqlllist = new ArrayList<JieXiEntity>();
		DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		int nn = 1;
		String tyrq = null;
		String qyrq = null;
		for (LlbEntity ll : lllist) {
			if (nn == 1) {
				tyrq = ll.getEnddate();
				qyrq = ll.getBegdate();
				JieXiEntity jx = new JieXiEntity();
				try {
					if (sdf.parse(tyrq).getTime() > sdf.parse(map.get("endtime")).getTime()) {// 判断利率表中停用日期是否大于前面返回的年度终止日期
						// 由于lltype=1，所以绑定活期利率集合
						jx.setDatebeg(map.get("endtime"));
					} else {
						jx.setDatebeg(tyrq);
					}
					jx.setRll(ll.getLl() / 360);
					hqlllist.add(jx);
				} catch (ParseException e) {
					e.printStackTrace();
				}
			} else {
				JieXiEntity jx = new JieXiEntity();
				java.util.Date date = null;
				try {
					date = sdf.parse(tyrq);
				} catch (ParseException e) {
					e.printStackTrace();
				} // Date格式
				Calendar calBegin = Calendar.getInstance();
				// 使用给定的 Date 设置此 Calendar 的时间
				calBegin.setTime(date);
				calBegin.add(Calendar.DAY_OF_MONTH, 1);
				String datestr = sdf.format(calBegin.getTime());// String格式
				try {
					if (sdf.parse(datestr).getTime() != sdf.parse(ll.getBegdate()).getTime()) {// 停用日期加1必须是下一种利率的启用日期
						hqlllist.clear();
						break;
					}
					tyrq = ll.getEnddate();
					qyrq = ll.getBegdate();
					if (sdf.parse(tyrq).getTime() > sdf.parse(map.get("endtime")).getTime()) {// 判断利率表中停用日期是否大于前面返回的年度终止日期
						// 由于lltype=1，所以绑定活期利率集合
						jx.setDatebeg(map.get("endtime"));
					} else {
						jx.setDatebeg(tyrq);
					}
					jx.setRll(ll.getLl() / 360);
					hqlllist.add(jx);
				} catch (ParseException e) {
					e.printStackTrace();
				}
			}
			nn = nn + 1;
		}
		return hqlllist;
	}

	@Override
	public void insertywpzjx(YwpzEntity ywpzEntity) {

		baseMapper.insertywpzjx(ywpzEntity);
	}

	@Override
	public ZhxxEntity selectdwbydh(String id) {
		return baseMapper.selectdwbydh(id);
	}

	@Override
	public void caljdf(String id) {
		baseMapper.updatedf(id);
		baseMapper.updatejf(id);
	}

	@Override
	public HashMap<String, Double> calcuratioyearfd(FwxxEntity fwxxEntity, HashMap<String, String> map,
			List<JieXiEntity> listjiexill) {
		HashMap<String, Double> map3 = new HashMap<String, Double>();
		DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Double nLX = 0.0;
		Double nDQNCYE = fwxxEntity.getNcye();
		Double nHQLX = 0.0;
		Double nDQLX = 0.0;
		Double nHQYE = 0.0;
		Double ndq = 0.0;
		Double nhq = 0.0;
		String DJXRQ = map.get("begtime");
		map.put("id", fwxxEntity.getFwbm());
		List<HPzEntity> list = baseMapper.selectsumjdf(map);
		// 冲缴存处理
		YwpzEntity y = baseMapper.selectcjc(map);// ncje
		// 支取过处理
		YwpzEntity y2 = baseMapper.selectzqcl(map);// nzje
		Double nje = y.getNcje() - y2.getNzje();
		nDQNCYE = nDQNCYE + nje;
		nHQYE = -nje;
		if (nDQNCYE < 0) {
			nDQNCYE = 0.0;
			nHQYE = nDQNCYE;
		}
		for (HPzEntity Tcursor : list) {
			try {
				if (sdf.parse(Tcursor.getRzrq()).getTime() <= sdf.parse(map.get("endtime")).getTime()) {
					// if (nDQNCYE > 0) { // 调用计算结息的方法
					// ndq = CalcuRatioinfo(listjiexill, DJXRQ,
					// Tcursor.getRzrq(), nDQNCYE);
					// nDQLX = nDQLX + ndq;
					// }
					if (nHQYE > 0) {
						// 调用计算结息的方法
						nhq = CalcuRatioinfo(listjiexill, DJXRQ, Tcursor.getRzrq(), nHQYE);
						nHQLX = nHQLX + nhq;
					}
				} else {
					// if (nDQNCYE > 0) { // 调用计算结息的方法
					// ndq = CalcuRatioinfo(listjiexill, DJXRQ,
					// map.get("endtime"), nDQNCYE);
					// nDQLX = nDQLX + ndq;
					// }
					if (nHQYE > 0) {
						// 调用计算结息的方法
						nhq = CalcuRatioinfo(listjiexill, DJXRQ, map.get("endtime"), nHQYE);
						nHQLX = nHQLX + nhq;
					}
					java.util.Date date1 = null;
					try {
						date1 = sdf.parse(map.get("endtime"));
					} catch (ParseException e) {
						e.printStackTrace();
					} // Date格式
					Calendar calBegin1 = Calendar.getInstance();
					// 使用给定的 Date 设置此 Calendar 的时间
					calBegin1.setTime(date1);
					calBegin1.add(Calendar.DAY_OF_MONTH, 1);
					String datestr1 = sdf.format(calBegin1.getTime());// String格式
					DJXRQ = datestr1;
					ndq = 0.0;
					nhq = 0.0;
					break;
				}
				// 先存再冲
				// 贷方
				nHQYE = nHQYE + Tcursor.getDf();
				if (nHQYE < 0) {
					break;
				}
				// 支取
				if (Tcursor.getJf() > 0) {
					nHQYE = nHQYE - Tcursor.getJf();
					if (nHQYE < 0) {
						break;
					}
				} else {
					// 冲支取
					if (Tcursor.getJf() < 0) {
						nHQYE = nHQYE - Tcursor.getJf();
					}
				}
				DJXRQ = Tcursor.getRzrq();
				ndq = 0.0;
				nhq = 0.0;
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}
		try {
			if (sdf.parse(DJXRQ).getTime() <= sdf.parse(map.get("endtime")).getTime()) {
				// if (nDQNCYE > 0) {
				// // 调用计算结息的方法
				// ndq = CalcuRatioinfo(listjiexill, DJXRQ, map.get("endtime"),
				// nDQNCYE);
				// nDQLX = nDQLX + ndq;
				// }
				if (nHQYE > 0) {
					// 调用计算结息的方法
					nhq = CalcuRatioinfo(listjiexill, DJXRQ, map.get("endtime"), nHQYE);
					nHQLX = nHQLX + nhq;
				}
			}
			BigDecimal bg = new BigDecimal((nDQLX + nHQLX));
			double f1 = bg.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();// 四舍五入保留两位小数
			nLX = f1;
			// 计算定期积数、活期积数
			Double nHQJS = 0.0;
			Double nDQJS = 0.0;
			map3.put("nLX", nLX);
			map3.put("nDQLX", nDQLX);
			map3.put("nHQLX", nHQLX);
			map3.put("nDQJS", nDQJS);
			map3.put("nHQJS", nHQJS);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return map3;
	}

	@Override
	public Double CalcuRatioinfo(List<JieXiEntity> listjiexill, String id, String id2, Double rzje) {// 计算结息的方法
		DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		java.util.Date date = null;
		java.util.Date date2 = null;
		try {
			date = sdf.parse(id2);
			date2 = sdf.parse(id);
		} catch (ParseException e) {
			e.printStackTrace();
		} // Date格式
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(date);
		calBegin.add(Calendar.DAY_OF_MONTH, -1);
		String datestr = sdf.format(calBegin.getTime());// String格式
		id2 = datestr;
		Double NRZJE = 0.0;
		String djxrq = id2;
		for (int i = 0; i < listjiexill.size(); i++) {
			try {
				java.util.Date date1 = null;
				try {
					date1 = sdf.parse(listjiexill.get(i).getDatebeg());
				} catch (ParseException e) {
					e.printStackTrace();
				} // Date格式
				Calendar calBegin1 = Calendar.getInstance();
				// 使用给定的 Date 设置此 Calendar 的时间
				calBegin1.setTime(date1);
				calBegin1.add(Calendar.DAY_OF_MONTH, 1);
				String datestr1 = sdf.format(calBegin1.getTime());// String格式
				if (sdf.parse(id2).getTime() < sdf.parse(datestr1).getTime()) {
					if (sdf.parse(id).getTime() <= sdf.parse(listjiexill.get(i).getDatebeg()).getTime()) {
						NRZJE = NRZJE + ((date2.getTime() - date.getTime()) / (24 * 60 * 60 * 1000))
								* listjiexill.get(i).getRll() * (rzje);
						break;
					} else {
						NRZJE = NRZJE + ((date1.getTime() - date.getTime()) / (24 * 60 * 60 * 1000))
								* listjiexill.get(i).getRll() * (rzje);
					}
				}
				if (sdf.parse(datestr).getTime() < sdf.parse(datestr1).getTime()) {
					djxrq = datestr1;
				}
			} catch (ParseException e) {
				e.printStackTrace();
			}
		}
		return NRZJE;
	}

	@Override
	public void insertywpzjiexi(YwpzmxEntity ywpzmxEntity) {

		baseMapper.insertywpzjiexi(ywpzmxEntity);
	}

	@Override
	public void deleteywpzbyid(String id) {

	}

	@Override
	public void updateywpzbyid(YwpzEntity ywpzEntity) {

		baseMapper.updateywpzbyid(ywpzEntity);
	}

	@Override
	public ZhxxEntity selectzhxx(String id) {

		return baseMapper.selectzhxx1(id);
	}

	@Override
	public void updateZhxx(ZhxxEntity zhxxEntity) {

		baseMapper.updateZhxx(zhxxEntity);
	}

	@Override
	public PageInfo<ZhxxEntity> queryByPagePLJX(Integer pageNum, Integer pageSize) {
		PageHelper.startPage(pageNum, pageSize);
		List<ZhxxEntity> listzhxx = baseMapper.queryByPagePLJX();
		PageInfo<ZhxxEntity> pageInfo = new PageInfo<ZhxxEntity>(listzhxx);
		return pageInfo;
	}

	@Override
	public List<FwxxEntity> selectfwxx2() {

		return baseMapper.selectfwxx2();
	}

	@Override
	public void deletegryjx() {

		baseMapper.deletegryjx();
	}

	@Override
	public void insertgryjx(HGryjxEntity hGryjxEntity) {

		baseMapper.insertgryjx(hGryjxEntity);
	}

	@Override
	public PageInfo<HGryjxEntity> queryByPageYJLX(Integer pageNum, Integer pageSize, String xsfs) {
		PageHelper.startPage(pageNum, pageSize);
		List<HGryjxEntity> hGryjxEntities = new ArrayList<HGryjxEntity>();
		if ("fw".equals(xsfs)) {
			hGryjxEntities = baseMapper.queryByPageYJLXFW();
		} else if ("lz".equals(xsfs)) {
			hGryjxEntities = baseMapper.queryByPageYJLXLZ();
		}

		PageInfo<HGryjxEntity> pageInfo = new PageInfo<HGryjxEntity>(hGryjxEntities);
		return pageInfo;
	}

	@Override
	public List<YwpzEntity> selectfzhsmx(String time) {
		// 数据库中目前是从2007-11才开始有业务数据的
		// 暂定起始日期（起始归集会计期间）为2005-01，则2005-01辅助核算余额表每个项目的期初余额为0.
		// 先算djlx=01当前归集会计期间每个项目的贷方发生额：
		List<YwpzEntity> list1 = baseMapper.selectfzhsmx(time);

		List<YwpzEntity> list2 = new ArrayList<YwpzEntity>();// 一个单据编号对应多个项目编码
		List<YwpzEntity> list3 = new ArrayList<YwpzEntity>();// 一个单据编号对应一个项目编码
		for (YwpzEntity y : list1) {
			if (y.getXmbm().length() > 9) {
				list2.add(y);
			} else {
				list3.add(y);
			}
		}
		List<Map<String, Object>> list4 = new ArrayList<Map<String, Object>>();
		for (YwpzEntity y : list3) {
			Map<String, Object> map1 = new HashMap<String, Object>();
			map1.put("xmbm", y.getXmbm());
			map1.put("dffse", y.getDffse());
			list4.add(map1);
		}
		for (YwpzEntity y : list2) {
			List<YwpzEntity> l = baseMapper.selectfffff(y.getDjbh());
			for (YwpzEntity y2 : l) {
				Map<String, Object> map1 = new HashMap<String, Object>();
				map1.put("xmbm", y2.getXmbm());
				map1.put("dffse", y2.getDffse());
				list4.add(map1);
			}
		}
		Map<String, Object> result1 = new HashMap<String, Object>();
		for (Map<String, Object> map : list4) {
			String id = map.get("xmbm").toString();
			Double value = Double.parseDouble(map.get("dffse").toString());
			if (result1.containsKey(id)) {
				Double temp = Double.parseDouble(result1.get(id).toString());
				value += temp;
			}
			result1.put(id, value);
		}

		List<YwpzEntity> listallxm = baseMapper.selectxmbm555();
		for (YwpzEntity s : listallxm) {
			Boolean x = result1.containsKey(s.getXmbm());
			if (x == false) {
				result1.put(s.getXmbm(), 0.0);
			}
		}
		System.out.println("单据类型为01合并后的数据：" + result1);// result1为当前归集时间单据类型为01的每个项目的本月发生额
		// ------------------------------------------------------------------------------------------
		// 再算djlx=03当前归集会计期间每个项目的贷方发生额：
		List<YwpzEntity> list03 = baseMapper.selectfzhsmx03(time);
		List<Map<String, Object>> listgr = new ArrayList<Map<String, Object>>();
		for (YwpzEntity y : list03) {
			Map<String, Object> map1 = new HashMap<String, Object>();
			map1.put("xmbm", y.getXmbm());
			map1.put("dffse", y.getDffse());
			listgr.add(map1);
		}
		Map<String, Object> result2 = new HashMap<String, Object>();
		for (Map<String, Object> map : listgr) {
			String id = map.get("xmbm").toString();
			Double value = Double.parseDouble(map.get("dffse").toString());
			if (result2.containsKey(id)) {
				Double temp = Double.parseDouble(result2.get(id).toString());
				value += temp;
			}
			result2.put(id, value);
		}

		for (YwpzEntity s : listallxm) {
			Boolean x = result2.containsKey(s.getXmbm());
			if (x == false) {
				result2.put(s.getXmbm(), 0.0);
			}
		}
		System.out.println("单据类型为03合并后的数据：" + result2);// result2为当前归集时间单据类型为03的每个项目的本月发生额
		// -----------------------------------------------------------------------------------------------------
		// 判断当前归集会计期间是否是起始时间：
		int res = time.compareTo("2005-01");// 暂定起始归集期间为2007-11
		if (res == 0) {// 则当前归集会计期间期初余额为0
			List<YwpzEntity> a1 = new ArrayList<YwpzEntity>();
			for (Map.Entry<String, Object> entry : result1.entrySet()) {// 计算01的的期末余额插入到余额表中
				YwpzEntity y0 = new YwpzEntity();
				y0.setGjkjqj(time);
				y0.setXmbm(entry.getKey());
				y0.setDjlx("01");
				y0.setQcye(0.0);
				y0.setJffse(0.0);
				y0.setDffse(Double.parseDouble(entry.getValue().toString()));
				y0.setQmye(Double.parseDouble(entry.getValue().toString()));
				a1.add(y0);
			}
			baseMapper.insertfzhsyeList(a1);
			List<YwpzEntity> a2 = new ArrayList<YwpzEntity>();
			for (Map.Entry<String, Object> entry : result2.entrySet()) {// 计算03的的期末余额插入到余额表中
				YwpzEntity y0 = new YwpzEntity();
				y0.setGjkjqj(time);
				y0.setXmbm(entry.getKey());
				y0.setDjlx("03");
				y0.setQcye(0.0);
				y0.setJffse(0.0);
				y0.setDffse(Double.parseDouble(entry.getValue().toString()));
				y0.setQmye(Double.parseDouble(entry.getValue().toString()));
				a2.add(y0);
			}
			baseMapper.insertfzhsyeList(a2);
			// --------------------------------------------------------------------------------------------------------------
			// 上面是月结只记录了当月的发生和期末，还应插入下月的期初
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			java.util.Date date = null;
			try {
				date = formatter.parse(time);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin.setTime(date);
			calBegin.add(Calendar.MONTH, 1);
			String datestr = formatter.format(calBegin.getTime());// String格式
			// ---------------------------------------------------------------------
			List<YwpzEntity> a3 = new ArrayList<YwpzEntity>();
			for (Map.Entry<String, Object> entry : result1.entrySet()) {// 计算下个月01的的期末余额插入到余额表中
				YwpzEntity y0 = new YwpzEntity();
				y0.setGjkjqj(datestr);
				y0.setXmbm(entry.getKey());
				y0.setDjlx("01");
				y0.setQcye(Double.parseDouble(entry.getValue().toString()));
				y0.setJffse(0.0);
				y0.setDffse(0.0);
				y0.setQmye(0.0);
				a3.add(y0);
			}
			baseMapper.insertfzhsyeList(a3);

			List<YwpzEntity> a4 = new ArrayList<YwpzEntity>();
			for (Map.Entry<String, Object> entry : result2.entrySet()) {// 计算下个月03的的期末余额插入到余额表中
				YwpzEntity y0 = new YwpzEntity();
				y0.setGjkjqj(datestr);
				y0.setXmbm(entry.getKey());
				y0.setDjlx("03");
				y0.setQcye(Double.parseDouble(entry.getValue().toString()));
				y0.setJffse(0.0);
				y0.setDffse(0.0);
				y0.setQmye(0.0);
				a4.add(y0);
			}
			baseMapper.insertfzhsyeList(a4);
			// --------------------------------------------------------------------------------------------------------------
		} else if (res > 0) {// 则当前归集会计期间的期初余额是上一个月的期末余额，//计算01的的期末余额插入到余额表中
			// 先查上一个月每个项目的期末余额
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			java.util.Date date = null;
			try {
				date = formatter.parse(time);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin.setTime(date);
			calBegin.add(Calendar.MONTH, -1);
			String datestr = formatter.format(calBegin.getTime());// String格式
			// 查fzhsye表上一个月01类型的qmye
			List<YwpzEntity> list0101 = baseMapper.selectfzhsye(datestr);
			List<YwpzEntity> a7 = new ArrayList<YwpzEntity>();
			for (int i = 0; i < list0101.size(); i++) {
				for (Map.Entry<String, Object> entry : result1.entrySet()) {
					if (list0101.get(i).getXmbm().equals(entry.getKey())) {
						YwpzEntity d = new YwpzEntity();
						d.setGjkjqj(time);
						d.setXmbm(list0101.get(i).getXmbm());
						d.setDjlx("01");
						d.setQcye(list0101.get(i).getQmye());
						d.setJffse(0.0);
						d.setDffse(Double.parseDouble(entry.getValue().toString()));
						d.setQmye(list0101.get(i).getQmye() + Double.parseDouble(entry.getValue().toString()));
						a7.add(d);
						// baseMapper.updatefzhsye2(d);
					}
				}
			}
			baseMapper.updatefzhsye2List(a7);

			// 查fzhsye表上一个月03类型的qmye
			List<YwpzEntity> list0303 = baseMapper.selectfzhsye03(datestr);
			List<YwpzEntity> a8 = new ArrayList<YwpzEntity>();
			for (int i = 0; i < list0303.size(); i++) {
				for (Map.Entry<String, Object> entry : result2.entrySet()) {
					if (list0303.get(i).getXmbm().equals(entry.getKey())) {
						YwpzEntity d = new YwpzEntity();
						d.setGjkjqj(time);
						d.setXmbm(list0303.get(i).getXmbm());
						d.setDjlx("03");
						d.setQcye(list0303.get(i).getQmye());
						d.setJffse(0.0);
						d.setDffse(Double.parseDouble(entry.getValue().toString()));
						d.setQmye(list0303.get(i).getQmye() + Double.parseDouble(entry.getValue().toString()));
						a8.add(d);
						// baseMapper.updatefzhsye2(d);
					}
				}
			}
			baseMapper.updatefzhsye2List(a8);
			// -----------------------------------------------------------------------------------------------------------------------
			// 上面是月结只记录了当月的发生和期末，还应插入下月的期初
			SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM");
			java.util.Date date2 = null;
			try {
				date2 = formatter2.parse(time);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin2 = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin2.setTime(date2);
			calBegin2.add(Calendar.MONTH, 1);
			String datestr2 = formatter2.format(calBegin2.getTime());// String格式
			// ---------------------------------------------------------------------
			List<YwpzEntity> a5 = new ArrayList<YwpzEntity>();
			for (int i = 0; i < list0101.size(); i++) {
				for (Map.Entry<String, Object> entry : result1.entrySet()) {
					if (list0101.get(i).getXmbm().equals(entry.getKey())) {
						YwpzEntity d = new YwpzEntity();
						d.setGjkjqj(datestr2);
						d.setXmbm(list0101.get(i).getXmbm());
						d.setDjlx("01");
						d.setQcye(list0101.get(i).getQmye() + Double.parseDouble(entry.getValue().toString()));
						d.setJffse(0.0);
						d.setDffse(0.0);
						d.setQmye(0.0);
						a5.add(d);
					}
				}
			}
			baseMapper.insertfzhsyeList(a5);

			List<YwpzEntity> a6 = new ArrayList<YwpzEntity>();
			for (int i = 0; i < list0303.size(); i++) {
				for (Map.Entry<String, Object> entry : result2.entrySet()) {
					if (list0303.get(i).getXmbm().equals(entry.getKey())) {
						YwpzEntity d = new YwpzEntity();
						d.setGjkjqj(datestr2);
						d.setXmbm(list0303.get(i).getXmbm());
						d.setDjlx("03");
						d.setQcye(list0303.get(i).getQmye() + Double.parseDouble(entry.getValue().toString()));
						d.setJffse(0.0);
						d.setDffse(0.0);
						d.setQmye(0.0);
						a6.add(d);
					}
				}
			}
			baseMapper.insertfzhsyeList(a6);
			// -----------------------------------------------------------------------------------------------------------------

		}

		return null;
	}

	@Override
	public List<YwpzEntity> selectfzhsmxfyj(String time) {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
		java.util.Date date = null;
		try {
			date = formatter.parse(time);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // Date格式
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(date);
		calBegin.add(Calendar.MONTH, -1);
		String datestr = formatter.format(calBegin.getTime());// String格式
		baseMapper.deletefzhsye(time);
		baseMapper.updatefzhsye(datestr);
		return null;
	}

	@Override
	public List<YwpzEntity> selectfZQFT(String time) {
		// 查所有的项目
		List<YwpzEntity> listallxm = baseMapper.selectxmbm555();
		// 将所有的项目，插入21，22类型，从2005-01刷到当前月到fzhsye表中，
		for (YwpzEntity y : listallxm) {
			y.setDjlx("21");
			y.setGjkjqj(time);
			y.setQcye(0.0);
			y.setJffse(0.0);
			y.setDffse(0.0);
			y.setQmye(0.0);
			y.setZqlx("01");
			baseMapper.insertfzhsye(y);
			y.setDjlx("21");
			y.setGjkjqj(time);
			y.setQcye(0.0);
			y.setJffse(0.0);
			y.setDffse(0.0);
			y.setQmye(0.0);
			y.setZqlx("03");
			baseMapper.insertfzhsye(y);
		}

		// for(YwpzEntity y:listallxm){
		// y.setDjlx("22");
		// y.setGjkjqj(time);
		// y.setQcye(0.0);
		// y.setJffse(0.0);
		// y.setDffse(0.0);
		// y.setQmye(0.0);
		// y.setZqlx("01");
		// baseMapper.insertfzhsye(y);
		// y.setDjlx("22");
		// y.setGjkjqj(time);
		// y.setQcye(0.0);
		// y.setJffse(0.0);
		// y.setDffse(0.0);
		// y.setQmye(0.0);
		// y.setZqlx("03");
		// baseMapper.insertfzhsye(y);
		// }

		return null;
	}

	@Override
	public void deletefzhsmxgrdw(String id) {

		baseMapper.deletefzhsmxgrdw(id);
	}

	@Override
	public void deletefzhsmxgrdwnext(String id) {
		baseMapper.deletefzhsmxgrdwnext(id);

	}

	@Override
	public List<YwpzEntity> selectfzhsmxsss(String time) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

		java.util.Date date1 = null;
		try {
			date1 = sdf.parse(time);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // Date格式
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(date1);
		calBegin.add(Calendar.MONTH, 1);
		String datestr = sdf.format(calBegin.getTime());// String格式下一个月
		// 查当月发生
		List<YwpzEntity> list1 = baseMapper.selectdyfs(time);
		List<YwpzEntity> list2 = baseMapper.selectdyfshs(time);

		for (YwpzEntity y2 : list2) {
			for (YwpzEntity y1 : list1) {
				if (y2.getDjlx().equals(y1.getDjlx()) && y2.getXmbm().equals(y1.getXmbm())) {
					y2.setDffse(y2.getDffse()+y1.getDffse());
					y2.setQmye(y2.getQcye() + y2.getDffse());
					baseMapper.updatefzhsye2(y2);
				}
			}
		}
		List<YwpzEntity> list3 = baseMapper.selectdyfshs(time);
		for (YwpzEntity y3 : list3) {
			if (y3.getDffse() == 0.0) {
				YwpzEntity yy = new YwpzEntity();
				yy.setQcye(y3.getQcye());
				yy.setXmbm(y3.getXmbm());
				yy.setDjlx(y3.getDjlx());
				yy.setJffse(0.0);
				yy.setDffse(0.0);
				yy.setGjkjqj(y3.getGjkjqj());
				yy.setQmye(y3.getQcye());
				baseMapper.updatefzhsye2(yy);
			}
		}
		List<YwpzEntity> list4 = baseMapper.selectdyfshs(time);
		for (YwpzEntity y3 : list4) {
				YwpzEntity yy = new YwpzEntity();
				yy.setQcye(y3.getQmye());
				yy.setXmbm(y3.getXmbm());
				yy.setDjlx(y3.getDjlx());
				yy.setJffse(0.0);
				yy.setDffse(0.0);
				yy.setGjkjqj(datestr);
				yy.setQmye(0.0);
				baseMapper.insertfzhsye(yy);
		}
		
		return null;
	}

}
