package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.SqwxzqEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.FwwxdshService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 房屋维修单审核
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-11 10:12:38
 */
@RestController
@RequestMapping("app/sqwxzqsh")
@Api(tags = "房屋维修单审核")
public class FwwxdshController {

	@Autowired
	private FwwxdshService fwwxdshService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "房屋维修单审核查询列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = SqwxzqEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {

		return R.ok().put("data", fwwxdshService.queryByPage(pageNum, pageSize, sqwxzqEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = SqwxzqEntity.class)
	public R insert(@RequestBody SqwxzqEntity sqwxzqEntity) {
		fwwxdshService.insert(sqwxzqEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/updatetgsh")
	@ApiOperation(value = "对未审核的单据点击审核按钮，输入审批内容点击审核通过掉的接口", notes = "在此补充接口详细注释...", response = SqwxzqEntity.class)
	public R updatetgsh(@RequestBody SqwxzqEntity sqwxzqEntity) {
		fwwxdshService.updatedjzt(sqwxzqEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/updateqxsh")
	@ApiOperation(value = "对已审核的单据点击取消审核按钮，掉的接口", notes = "在此补充接口详细注释...", response = SqwxzqEntity.class)
	public R updateqxsh(@RequestBody SqwxzqEntity sqwxzqEntity) {
		fwwxdshService.updateqxsh(sqwxzqEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/updatebh")
	@ApiOperation(value = "对未审核的单据点击驳回按钮，掉的接口", notes = "在此补充接口详细注释...", response = SqwxzqEntity.class)
	public R updatebh(@RequestBody SqwxzqEntity sqwxzqEntity) {
		fwwxdshService.updatebh(sqwxzqEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = SqwxzqEntity.class)
	public R delete(@RequestBody String[] ids) {
		fwwxdshService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@GetMapping("queryByPageC")
	@ApiOperation(value = "支取分摊模块分页查询列表接口", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = SqwxzqEntity.class)
	public R queryByPageC(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {

		return R.ok().put("data", fwwxdshService.queryByPageC(pageNum, pageSize, sqwxzqEntity));
	}

	@Login
	@GetMapping("queryByPageF")
	@ApiOperation(value = "分摊页面点击分摊按钮，返回该单据楼幢下的所有房屋信息", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = FwxxEntity.class)
	public R queryByPageF(Integer pageNum, Integer pageSize, FwxxEntity fwxxEntity) {

		return R.ok().put("data", fwwxdshService.queryByPageF(pageNum, pageSize, fwxxEntity));
	}

	@Login
	@PostMapping("/insertft")
	@ApiOperation(value = "分摊新增页面点击保存按钮", notes = "在此补充接口详细注释...")
	public R insertft(@RequestBody YwpzEntity ywpzEntity) {
		fwwxdshService.insertft(ywpzEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/selectxq")
	@ApiOperation(value = "详情按钮返回分摊的房屋信息", notes = "在此补充接口详细注释...", response = FwxxEntity.class)
	public R selectft(@RequestBody SqwxzqEntity sqwxzqEntity) {

		return R.ok().put("data", fwwxdshService.selectftfw(sqwxzqEntity));
	}

	@Login
	@PostMapping("/deleteft")
	@ApiOperation(value = "分摊删除按钮", notes = "在此补充接口详细注释...")
	public R deleteft(@RequestBody SqwxzqEntity sqwxzqEntity) {
		fwwxdshService.deleteft(sqwxzqEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/inserthb")
	@ApiOperation(value = "划拨新增页面点击保存按钮", notes = "在此补充接口详细注释...")
	public R inserthb(@RequestBody YwpzEntity ywpzEntity) {
		fwwxdshService.inserthb(ywpzEntity);
		return R.ok();
	}

	@Login
	@GetMapping("queryByPageHB")
	@ApiOperation(value = "支取划拨分页查询页面列表信息", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = SqwxzqEntity.class)
	public R queryByPageHB(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {

		return R.ok().put("data", fwwxdshService.queryByPageHB(pageNum, pageSize, sqwxzqEntity));
	}

	@Login
	@PostMapping("/deleteHB")
	@ApiOperation(value = "划拨删除按钮", notes = "在此补充接口详细注释...")
	public R deleteBH(@RequestBody SqwxzqEntity sqwxzqEntity) {
		fwwxdshService.deleteHB(sqwxzqEntity);
		return R.ok();
	}

	@Login
	@GetMapping("queryByPageJS")
	@ApiOperation(value = "支取决算分页查询页面列表信息", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = SqwxzqEntity.class)
	public R queryByPageJS(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {

		return R.ok().put("data", fwwxdshService.queryByPageJS(pageNum, pageSize, sqwxzqEntity));
	}

	@Login
	@PostMapping("/insertjs")
	@ApiOperation(value = "决算新增页面点击保存按钮", notes = "在此补充接口详细注释...")
	public R insertjs(@RequestBody YwpzEntity ywpzEntity) {
		fwwxdshService.insertjs(ywpzEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/deleteJS")
	@ApiOperation(value = "结算删除按钮", notes = "在此补充接口详细注释...")
	public R deleteJS(@RequestBody SqwxzqEntity sqwxzqEntity) {
		fwwxdshService.deleteJS(sqwxzqEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/selectfwxq")
	@ApiOperation(value = "业主退款新增页面门派下拉框选择某个房屋返回房屋信息", notes = "在此补充接口详细注释...", response = FwxxEntity.class)
	public R selectfwxq(@RequestBody FwxxEntity fwxxEntity) {

		return R.ok().put("data", fwwxdshService.selectfwxq(fwxxEntity));
	}

	//@Login
	@GetMapping("queryByPageYZTK")
	@ApiOperation(value = "支取业主退款分页查询页面列表信息", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = YwpzEntity.class)
	public R queryByPageYZTK(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", fwwxdshService.queryByPageYZTK(pageNum, pageSize, ywpzEntity));
	}
	
	@Login
	@PostMapping("/insertYZTK")
	@ApiOperation(value = "业主退款新增页面点击保存按钮", notes = "在此补充接口详细注释...")
	public R insertYZTK(@RequestBody YwpzEntity ywpzEntity) {
		fwwxdshService.insertyztk(ywpzEntity);
		return R.ok();
	}
	
	@Login
	@PostMapping("/deleteYZTK")
	@ApiOperation(value = "业主退款删除按钮", notes = "在此补充接口详细注释...")
	public R deleteYZTK(@RequestBody YwpzEntity ywpzEntity) {
		fwwxdshService.deleteyztk(ywpzEntity);
		return R.ok();
	}
	
	@Login
	@PostMapping("/insertYZXH")
	@ApiOperation(value = "业主销户新增页面点击保存按钮", notes = "在此补充接口详细注释...")
	public R insertYZXH(@RequestBody YwpzEntity ywpzEntity) {
		fwwxdshService.insertyzxh(ywpzEntity);
		return R.ok();
	}
	
	
	@Login
	@GetMapping("queryByPageYZXH")
	@ApiOperation(value = "支取业主销户分页查询页面列表信息", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = YwpzEntity.class)
	public R queryByPageYZXH(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", fwwxdshService.queryByPageYZXH(pageNum, pageSize, ywpzEntity));
	}
	
	
	@PostMapping("/zqdjbhjsdbh")
	@ApiOperation(value = "（脚本）由于支取现在可以按小区录，存在多个项目，所以两个分摊功能修改后，整改之前录的支取数据，sqwxzq表中的djbh和jsdbh，xmbm需要挪到ywpz表的sqdbh，xgbm", notes = "")
	public R zqdjbhjsdbh() {
		fwwxdshService.zqdjbhjsdbh();
		return R.ok();
	}
	
	//@Login
	@GetMapping("queryByPageZQMX")
	@ApiOperation(value = "支取明细分页查询页面列表信息", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = FwxxEntity.class)
	public R queryByPageZQMX(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", fwwxdshService.queryByPageZQMX(pageNum, pageSize, ywpzEntity));
	}
	
	@PostMapping("/SCFTfwftjb")
	@ApiOperation(value = "（脚本）将每一户历史支取分摊的金额记录在每一户的明细中", notes = "")
	public R fwftjb() {
		fwwxdshService.ftddddd();
		return R.ok();
	}
	
	@PostMapping("/YEFTfwftjb")
	@ApiOperation(value = "（脚本）将每一户历史支取分摊的金额记录在每一户的明细中", notes = "")
	public R fwftjb2() {
		fwwxdshService.ftddddd2();
		return R.ok();
	}

}
