package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.WtTyEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.ZhxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 楼盘幢号(楼宇)信息表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-14 11:34:32
 */
@RestController
@RequestMapping("app/zhxx")
@Api(tags = "楼盘幢号(楼宇)信息表模块")
public class ZhxxController {

	@Autowired
	private ZhxxService zhxxService;

	// @Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = ZhxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, ZhxxEntity zhxxEntity) {
		return R.ok().put("data", zhxxService.queryByPage(pageNum, pageSize, zhxxEntity));
	}

	// @Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = ZhxxEntity.class)
	public R insert(@RequestBody ZhxxEntity zhxxEntity) {
		// 限制同一项目下不允许建楼幢名称相同的楼幢。
		// 1.查询该项目下所有的楼幢，判断该楼幢的名称是否在查询出来的楼幢里出现过，如果出现过则不允许新增该楼幢。
		List<ZhxxEntity> l = zhxxService.selectzhxx(zhxxEntity.getXmbm());
		for (ZhxxEntity z : l) {
			if (zhxxEntity.getDhmc().equals(z.getDhmc())) {
				return R.error("该项目下已存在此楼幢名称的楼幢，请更改楼幢名称");
			}
		}
		// 主键定义
		String a = zhxxService.querydhbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String dhbm = b + c;
		zhxxEntity.setDhbm(dhbm);
		zhxxEntity.setGzdbm("0001");
		zhxxEntity.setHs(0);
		zhxxEntity.setZje(0.00);
		zhxxService.insert(zhxxEntity);
		String jsbz = zhxxEntity.getJsbz();
		if ("0".equals(jsbz)) {
			Double je = zhxxEntity.getZmj() * zhxxEntity.getJkbz();
			Double Yjje = (double) Math.round(je);
			zhxxEntity.setYjje(Yjje);
			zhxxService.updatezhxxyjje(zhxxEntity);
		}else if("1".equals(jsbz)){
			Double je = zhxxEntity.getZje() * zhxxEntity.getJkbz();
			Double Yjje = (double) Math.round(je);
			zhxxEntity.setYjje(Yjje);
			zhxxService.updatezhxxyjje(zhxxEntity);
		}
		return R.ok();
	}

	// @Login
	@PostMapping("/insertPLDR")
	@ApiOperation(value = "批量新增", notes = "在此补充接口详细注释...", response = ZhxxEntity.class)
	public R insertPLDR(@RequestBody List<ZhxxEntity> list) {

		for (ZhxxEntity zhxxEntity : list) {
			// 主键定义
			String a = zhxxService.querydhbm();
			String b = a.substring(0, 3);
			String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
			String dhbm = b + c;
			zhxxEntity.setDhbm(dhbm);
			zhxxEntity.setGzdbm("0001");
			zhxxEntity.setHs(0);
			zhxxService.insert(zhxxEntity);
		}
		return R.ok();
	}

	// @Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = ZhxxEntity.class)
	public R update(@RequestBody ZhxxEntity zhxxEntity) {
		zhxxService.updateById(zhxxEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = ZhxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		System.out.println("==========");
		zhxxService.deleteBatch(ids);
		return R.ok();
	}

	// 下拉列表
	// @Login
	@PostMapping("/selectXllx")
	@ApiOperation(value = "下拉框查询", notes = "", response = WtTyEntity.class)
	public R selectxlk(@RequestBody Map map) {
		return R.ok().put("select", zhxxService.selectXllx(map));
	}

	// @Login
	@PostMapping("/selectKM")
	@ApiOperation(value = "新增楼幢页面自动获取对应科目", notes = "", response = WtTyEntity.class)
	public R selectKM(@RequestBody ZhxxEntity zhxxEntity) {
		return R.ok().put("select", zhxxService.selectkm(zhxxEntity));
	}

}
