package io.renren.modules.app.dao;

import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzmxEntity;
import io.renren.modules.app.entity.ZhxxEntity;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 产权人信息（楼盘清册）表（房屋表）
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-26 09:43:59
 */
@Mapper
public interface FwxxDao extends BaseMapper<FwxxEntity> {

	/**
	 * 分页模糊查询
	 * 
	 * @param fwxxEntity
	 * @return
	 */
	List<FwxxEntity> queryByPage(FwxxEntity fwxxEntity);

	// 查询单元信息
	FwxxEntity queryDyxx(FwxxEntity fwxxEntity);

	// 下拉框查询
	List<FwxxEntity> selectxq();

	List<FwxxEntity> selectxm(Map<String, String> map);

	List<FwxxEntity> selectlz(Map<String, String> map);

	List<FwxxEntity> selectdy(Map<String, String> map);

	List<FwxxEntity> hx(Map<String, String> map);

	List<FwxxEntity> selectmhxq(@Param(value = "_pt") String _pt);

	List<FwxxEntity> fmxz(Map<String, String> map);

	// 获取最新的房屋编码
	String querydhbm();

	// 单个查询
	FwxxEntity selectByXxId(FwxxEntity fwxxEntity);

	// 修改
	void updateFwxx(FwxxEntity fwxxEntity);

	// 新增
	void insertFwxx(FwxxEntity fwxxEntity);

	// 查询单元信息
	List<FwxxEntity> queryFwjhDy(FwxxEntity fwxxEntity);

	// 查询房屋信息
	List<FwxxEntity> queryFwjhFw(Map<String, Object> pd);

	// 根据单元编码查询房屋楼层数集合
	List<Integer> queryDylcs(Map<String, Object> pd);

	// 新增房屋获取信息
	FwxxEntity queryDhsj(FwxxEntity fwxxEntity);

	// 查询是否有项目
	int selectIsdw(@Param("dwbm") String dwbm);

	// 删除单位
	int deleteFromSfdw(@Param("dwbm") String dwbm);

	List<YwpzEntity> selectfwdjbh(String id);

	YwpzEntity selectshzt(String id);

	void PLINSERTFwxx(FwxxEntity fwxxEntity);

	void updatezhxxhs(ZhxxEntity zhxxEntity);

	ZhxxEntity selectzhxxhs(String id);

	FwxxEntity selectfwxx(String id);

	List<YwpzEntity> selectfwdjxx(String id);
	
	YwpzmxEntity selectfwsfjq(String id);
}
