package io.renren.modules.app.entity;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 维修基金支取申请表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-11 10:12:38
 */
@Data
@TableName("sqwxzq")
@ApiModel(value = "维修基金支取申请表")
public class SqwxzqEntity implements Serializable {
	private static final long serialVersionUID = 1L;


	@ApiModelProperty("主键")
	@TableId
	private String id;

	@ApiModelProperty("申请单编号")
	private String sqdbh;
	@ApiModelProperty("申请日期")
	private String sqrq;
	@ApiModelProperty("申请单位编码（物业公司编码）")
	private String sqdwbm;
	@ApiModelProperty("栋号编码")
	private String dhbm;
	@ApiModelProperty("申请金额")
	private Double sqje;
	@ApiModelProperty("无用字段")
	private String lx;
	@ApiModelProperty("维修部位及内容")
	private String wxbw;
	@ApiModelProperty("项目预结算费用")
	private Double zfy;
	@ApiModelProperty("预分摊户数")
	private Integer zhs;
	@ApiModelProperty("申请单位意见")
	private String dwyj;
	@ApiModelProperty("物业管理委员会意见")
	private String gwhyj;
	@ApiModelProperty("审批单位意见")
	private String pzdwyj;
	@ApiModelProperty("经办人姓名")
	private String jbrxm;
	@ApiModelProperty("经办人电话")
	private String jbrdh;
	@ApiModelProperty("备注")
	private String bz;
	@ApiModelProperty("操作员编码")
	private String czybm;
	@ApiModelProperty("操作员编码")
	private String czyxm;
	@ApiModelProperty("归集点编码")
	private String gzdbm;
	@ApiModelProperty("审核人编码")
	private String shrbm;
	@ApiModelProperty("审核人姓名")
	private String shrxm;
	@ApiModelProperty("审核日期")
	private String shrq;
	@ApiModelProperty("审核标志(0取消审查,1审查通过,2审查退回)")
	private String sfsh;
	@ApiModelProperty("是否支取划拨")
	private String sfjz;
	@ApiModelProperty("承办网点编码")
	private String cbwdbm;
	@ApiModelProperty("是否分摊")
	private String sffp;
	@ApiModelProperty("分摊人编码")
	private String fprbm;
	@ApiModelProperty("分摊人姓名")
	private String fprxm;
	@ApiModelProperty("分摊日期（没用）")
	private String fprq;
	@ApiModelProperty("0按户分摊,1按面积分摊")
	private String fpfs;
	
	@ApiModelProperty("0按户分摊,1按面积分摊")
	private String fpfs2;
	@ApiModelProperty("分摊面积")
	private double mj;
	@ApiModelProperty("支取单号")
	private String djbh;
	@ApiModelProperty("决算单编号")
	private String jsdbh;
	@ApiModelProperty("是否决算")
	private String sfjs;
	@ApiModelProperty("申请单位")
	private String sqdw;
	@ApiModelProperty("会计期间")
	private String dqkjqj;
	@ApiModelProperty("单据类型")
	private String djlx;
	@ApiModelProperty("单据日期")
	private String djrq;
	@ApiModelProperty("售房单位编码")
	private String dwbm;
	@ApiModelProperty("银行编码")
	private String bank_code;
	@ApiModelProperty("结算号")
	private String zph;
	@ApiModelProperty("交款金额")
	private Double je;
	@ApiModelProperty("结算方式")
	private String jsfs;
	@ApiModelProperty("业务凭证状态0未审核1已审核2审核冲帐3冲账")
	private String pzzt;
	@ApiModelProperty("维修类别")
	private List<WxjlbEntity> wxlb;
	@ApiModelProperty("分摊明细")
	private List<FwxxEntity> ftmx;
	@ApiModelProperty("分摊明细")
	private List<FtqcEntity> ftfwlist;




	@ApiModelProperty("小区名称")
	private String xqmc;

	@ApiModelProperty("项目名称")
	private String xmmc;
	@ApiModelProperty("楼栋名称")
	private String dhmc;

	@ApiModelProperty("所在小区")
	private String xqbm;

	@ApiModelProperty("项目编码")
	private String xmbm;
	@ApiModelProperty("开始单据日期")
	private String beginrq;
    @ApiModelProperty("结束单据日期")
	private String endrq;
    @ApiModelProperty("审批金额")
	private Double spje;
    @ApiModelProperty("划拨日期")
	private String hbrq;
    @ApiModelProperty("结算银行")
	private String yhmc;
    @ApiModelProperty("结算方式")
	private String billname;
    @ApiModelProperty("决算金额")
	private Double jsje;
    @ApiModelProperty("决算人")
	private String jsr;
    @ApiModelProperty("决算日期")
	private String jsrq;
    @ApiModelProperty("结算银行")
	private String jsyh;
    @ApiModelProperty("结算方式")
	private String jsfshi;
    @ApiModelProperty("结算号")
	private String jsh;
    @ApiModelProperty("结算备注")
	private String jsbzhu;
    @ApiModelProperty("录入日期")
	private String lrrq;
    @ApiModelProperty("预算金额")
	private Double ysje;
    @ApiModelProperty("选择拨付类型(1首次拨付，2余额拨付)")
   	private String xzbflx;
    @ApiModelProperty("选择维修类型（1.普通维修2.应急维修3.紧急代修4.预审预拨）")
   	private String xzwxlx;
    @ApiModelProperty("上传的文件id")
   	private String fjid;
    @ApiModelProperty("维修单状态（1.已申请，2.已审核，3.首次拨付，4.余额拨付）")
   	private String wxdzt;
    @ApiModelProperty("上传的文件对象")
   	private FjEntity wjdx;
    @ApiModelProperty("文件名称")
	private String wjmc;
	
	@ApiModelProperty("文件类型")
	private String wjtype;
	
	@ApiModelProperty("文件全路径")
	private String wjqlj;
	
	@ApiModelProperty("文件大小")
	private String wjsize;
	
	@ApiModelProperty("创建日期")
	private String createtime;
	
	@ApiModelProperty("创建人id")
	private String creatid;
	
	@ApiModelProperty("文件种类（1.预算资金拨付申请表2.结算资金拨付申请表3.工程结算票据4.第三方审价票据）")
	private String wjzl;
	
	@ApiModelProperty("首次(余额)拨付前项目账户金额")
	private Double scbfqxmje;
	
	@ApiModelProperty("首次(余额)拨付后项目账户金额")
	private Double scbfhxmje;
	
	@ApiModelProperty("结算金额")
	private Double jiesuanje;
	
	@ApiModelProperty("余额拨付金额")
	private Double yebfje;
	
	@ApiModelProperty("")
	private String bankCode;
	
	@ApiModelProperty("施工单位")
	private String sgdw;
	
	@ApiModelProperty("第三方审价单位")
	private String dsfsj;
	
	@ApiModelProperty("第三方审价费用")
	private Double dsfsjfy;
	
	@ApiModelProperty("工程余额拨付金额")
	private Double gcyebfje;
}
