package io.renren.modules.app.service;

import com.baomidou.mybatisplus.service.IService;
import com.github.pagehelper.PageInfo;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

/**
 * 产权人信息（楼盘清册）表（房屋表）
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-26 09:43:59
 */
public interface FwxxService extends IService<FwxxEntity> {

	// 查询房屋图
	List<Map<String, Object>> queryFwjh(FwxxEntity fwxxEntity);

	// 根据单元查询出房屋列表
	PageInfo<FwxxEntity> queryByPage(FwxxEntity fwxxEntity);

	// 新增房屋获取信息
	FwxxEntity queryDhsj(FwxxEntity fwxxEntity);

	// 单个或批量删除
	void deleteBatch(String[] ids);

	// 获取编码
	String querydhbm();

	// 单个查询
	FwxxEntity selectByXxId(FwxxEntity fwxxEntity);

	// 修改
	void updateFwxx(FwxxEntity fwxxEntity);

	// 新增
	void insertFwxx(FwxxEntity fwxxEntity);

	// 下拉框查询
	List<FwxxEntity> selectxlk(Map<String, String> map);

	/**
	 * 查询是否有项目
	 * 
	 * @param dwbm
	 * @return
	 */
	int selectIsdw(@Param("dwbm") String dwbm);

	// 删除单位
	int deleteFromSfdw(@Param("dwbm") String dwbm);
	
	void PLINSERTFwxx(FwxxEntity fwxxEntity);
	
	void updatezhxxhs(ZhxxEntity zhxxEntity);
	
	ZhxxEntity selectzhxxhs(String id);
	
	List<YwpzEntity> selectdjxxbyfw(String id);
}
