package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.SysdocDao;
import io.renren.modules.app.entity.SysdocEntity;
import io.renren.modules.app.service.SysdocService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("sysdocService")
public class SysdocServiceImpl extends ServiceImpl<SysdocDao, SysdocEntity> implements SysdocService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param sysdocEntity
     * @return
     */
    @Override
    public PageInfo<SysdocEntity> queryByPage(Integer pageNum, Integer pageSize, SysdocEntity sysdocEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<SysdocEntity> sysdocEntitys = baseMapper.queryByPage(sysdocEntity);
        PageInfo<SysdocEntity> pageInfo = new PageInfo<SysdocEntity>(sysdocEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }


}