package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.WxzjyjDao;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.HPzEntity;
import io.renren.modules.app.entity.JkbzEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzTempEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.WxzjyjService;
import io.renren.modules.app.utils.MoneyUtil;

import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Service("wxzjyjService")
public class WxzjyjServiceImpl extends ServiceImpl<WxzjyjDao, YwpzEntity> implements WxzjyjService {

	// 预交页面开发单位下拉框选择对应单位编码和单位名称查询对应的幢号信息列表
	@Override
	public PageInfo<ZhxxEntity> queryByPage(Integer pageNum, Integer pageSize, ZhxxEntity zhxxEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<ZhxxEntity> listzhxx = baseMapper.queryByPage(zhxxEntity);
		String xmmc="";
		for(ZhxxEntity z:listzhxx){
			int fwyjhs=baseMapper.selectfwyjhs(z.getDhbm());
			xmmc=baseMapper.selectxmmcbydhbm(z.getDhbm());
			z.setXmmc(xmmc);
			z.setFwyjhs(fwyjhs);
		}
		PageInfo<ZhxxEntity> pageInfo = new PageInfo<ZhxxEntity>(listzhxx);
		return pageInfo;
	}

	// 编辑弹窗，修改该条幢号信息
	@Override
	public void updatezhxx(ZhxxEntity zhxxEntity) {
		String hwjg = baseMapper.selectsyscode(zhxxEntity.getHwjg());
		zhxxEntity.setHwjg(hwjg);
		baseMapper.updatezhxx(zhxxEntity);
	}

	@Override
	public List<XlkEntity> selectxlk(String id) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		id = id.replace("\"", "");
		if ("01".equals(id)) {

			list = baseMapper.selectdw();
			for (int i = 0; i < list.size(); i++) {
				// 判断每一个单位下在ywpz中djlx=‘01’是否有数据，
				List<String> list2 = baseMapper.selectyw(list.get(i).getDwbm());
				// List<String> strings=new ArrayList<String>();
				if (list2 != null && !list2.isEmpty()) {
					// for(int j=0;j<list2.size();j++){
					// strings.add(list2.get(j).getShzt());
					// }
					// 若有值，则判断所有单据shzt，只要有shzt=0则该单位存在未复核的单据，若所有shzt=1，则，该单位下的单据已全部复核
					if (list2.contains("0")) {
						list.get(i).setShzt(false);
					} else {
						list.get(i).setShzt(true);
					}
				} else {
					// 如果没有则该单位下没有未复核的单据
					list.get(i).setShzt(true);
				}

			}
		} else if ("02".equals(id)) {
			list = baseMapper.selectyh();
		} else if ("03".equals(id)) {
			list = baseMapper.selectjsfs();
		}
		return list;
	}

	@Override
	public void insertYj(YwpzEntity ywpzEntity) {
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);
		// ywpzEntity.setLrrq(temp_str);
		// 获取单据编号
		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "01" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "01" + temp_str1 + result;
		}
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("01");
		Double sum = 0.0;
		for (int i = 0; i < ywpzEntity.getListdhandsj().size(); i++) {
			sum = sum + ywpzEntity.getListdhandsj().get(i).getYjsjje();
			YwpzEntity y2 = new YwpzEntity();
			String uuid2 = UUID.randomUUID().toString().replaceAll("-", "");
			y2.setYjmxbm(uuid2);
			y2.setDhbm(ywpzEntity.getListdhandsj().get(i).getDhbm());
			y2.setDjbh(newdjbh);
			y2.setJe(ywpzEntity.getListdhandsj().get(i).getYjsjje());
			y2.setDjrq(ywpzEntity.getDjrq());
			y2.setJkfx("2");
			baseMapper.insertyjmx(y2);
		}
		ywpzEntity.setJe(sum);
		ywpzEntity.setGzdbm("0001");
		baseMapper.insertyj(ywpzEntity);
	}

	// -----新页面
	@Override
	public PageInfo<YwpzEntity> queryByPageC(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPageC(ywpzEntity);
		for (YwpzEntity y : ywpzEntitys) {
			String a = y.getJe().toString();
			y.setJedx(MoneyUtil.toChinese(a));
			ZhxxEntity z = baseMapper.selectzhmjh(y.getDjbh());
			y.setLzzmj(z.getZmj());
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	@Override
	public YwpzEntity selectCX(Map<String, String> map) {

		return baseMapper.selectck(map);
	}

	@Override
	public List<DhbmyjEntity> selectCXlz(Map<String, String> map) {
		List<DhbmyjEntity> list = baseMapper.selectyjmx(map.get("djbh"));
		return list;
	}

	@Override
	public void deletedj(YwpzEntity ywpzEntity) {
		baseMapper.deletedj(ywpzEntity.getDjbh());
		baseMapper.deletedjmx(ywpzEntity.getDjbh());
	}

	@Override
	public List<JkbzEntity> selectdwjjl(JkbzEntity jkbzEntity) {
		List<JkbzEntity> list = baseMapper.selectdwjjl(jkbzEntity);
		return list;
	}

	public List<XlkEntity> selectxlkdw() {
		List<XlkEntity> list = baseMapper.selectdw();
		List<YwpzEntity> listy = baseMapper.selectdj01();
		for (int i = 0; i < listy.size(); i++) {
			if ("0".equals(listy.get(i).getShzt())) {
				for (int j = 0; j < list.size(); j++) {
					if (listy.get(i).getDwbm().equals(list.get(j).getDwbm())) {
						list.get(j).setShzt(true);
					}
				}
			}
		}
		return list;
	}

	@Override
	public String insertYj2(YwpzEntity ywpzEntity) {
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);
		// ywpzEntity.setLrrq(temp_str);
		// 获取单据编号
		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "01" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "01" + temp_str1 + result;
		}
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("01");
		Double sum = 0.0;
		Double je = 0.0;
		for (int i = 0; i < ywpzEntity.getListdhandsj().size(); i++) {
			ZhxxEntity z = baseMapper.selectdhmjjkbz(ywpzEntity.getListdhandsj().get(i).getDhbm());
			je = z.getZmj() * z.getJkbz();
			// sum = sum + ywpzEntity.getListdhandsj().get(i).getYjsjje();
			YwpzEntity y2 = new YwpzEntity();
			String uuid2 = UUID.randomUUID().toString().replaceAll("-", "");
			y2.setYjmxbm(uuid2);
			y2.setDhbm(ywpzEntity.getListdhandsj().get(i).getDhbm());
			y2.setDjbh(newdjbh);
			y2.setJe(je);
			y2.setDjrq(ywpzEntity.getDjrq());
			y2.setJkfx("2");
			baseMapper.insertyjmx(y2);
		}
		ywpzEntity.setBankCode("00010001");
		ywpzEntity.setJsfs("31");
		ywpzEntity.setJe(je);
		ywpzEntity.setKjqj(ywpzEntity.getDjrq().substring(0, 7));
		ywpzEntity.setGzdbm("0001");
		baseMapper.insertyj(ywpzEntity);

		return newdjbh;
	}

	@Override
	public void updatedjrq(YwpzEntity ywpzEntity) {

		baseMapper.updateywpzdjrq(ywpzEntity);
		baseMapper.updateyjmxdjrq(ywpzEntity);
	}

	@Override
	public void zhxxyjje() {

		List<ZhxxEntity> list = baseMapper.selectzhxx();
		for (ZhxxEntity z : list) {
			String jsbz = z.getJsbz();
			if ("0".equals(jsbz)) {
				Double je = z.getZmj() * z.getJkbz();
				Double Yjje = (double) Math.round(je);
				z.setYjje(Yjje);
				baseMapper.updatezhxxyjje(z);
			}else if("1".equals(jsbz)){
				Double je = z.getZje() * z.getJkbz();
				Double Yjje = (double) Math.round(je);
				z.setYjje(Yjje);
				baseMapper.updatezhxxyjje(z);
			}
		}
	}

	@Override
	public void xlrjcsjyjje() {

		List<ZhxxEntity> listz=baseMapper.selectxlrdhbm();//获取新导入得dhbm
		for(ZhxxEntity z:listz){
				List<FwxxEntity> listfw=baseMapper.selectfwallbydh(z.getDhbm());
				ZhxxEntity z0=baseMapper.selectdhmjjkbz(z.getDhbm());
				Double sumyjje=0.0;
				for(FwxxEntity f:listfw){
					Double Yjje=0.0;
					if(!"".equals(f.getDwjjl())&&f.getDwjjl()!=null){
						Double je=f.getMj()*f.getDwjjl();
						Yjje = (double) Math.round(je);
					}else if("".equals(f.getDwjjl())||f.getDwjjl()==null){
						Double je=f.getMj()*z0.getJkbz();
						Yjje = (double) Math.round(je);
					}
					
					sumyjje=sumyjje+Yjje;
				}
				z.setYjje(sumyjje);
				baseMapper.updatezhxxyjje(z);
		}

	}

	@Override
	public void DWYJXQXG(YwpzEntity ywpzEntity) {
		
		baseMapper.updatedwxqxg(ywpzEntity);
	}

	@Override
	public void onexlrjcsjyjje() {
		String dhbm="000102449";
		List<FwxxEntity> listfw=baseMapper.selectfwallbydh(dhbm);
		Double zhjkbz=30.0;
		Double sumyjje=0.0;
		for(FwxxEntity f:listfw){
			Double Yjje=0.0;
			if(!"".equals(f.getDwjjl())&&f.getDwjjl()!=null){
				Double je=f.getMj()*f.getDwjjl();
				Yjje = (double) Math.round(je);
			}else if("".equals(f.getDwjjl())||f.getDwjjl()==null){
				Double je=f.getMj()*zhjkbz;
				Yjje = (double) Math.round(je);
			}
			
			sumyjje=sumyjje+Yjje;
		}
		ZhxxEntity z=new ZhxxEntity();
		z.setDhbm(dhbm);
		z.setYjje(sumyjje);
		baseMapper.updatezhxxyjje(z);
		
	}

	@Override
	public void xmmczhxxdhbm() {
		List<ZhxxEntity> list=baseMapper.selecttest();
		
		//2.通过项目编码和栋号名称找到对应的栋号编码
		for(ZhxxEntity z:list){
			ZhxxEntity z1=baseMapper.selectdhbmbytest(z);
			z.setDhbm(z1.getDhbm());
			baseMapper.updatedhbmtest(z);
		}
	}

	@Override
	public void dwyjghyjje() {
		//1.查询新楼盘已交的开发商业务数据
		List<YwpzEntity> list =baseMapper.selectdwdhyj();
		for(YwpzEntity y0:list){
			YwpzEntity y00=baseMapper.selectywpzdwbm(y0.getDjbh());
			y0.setDwbm(y00.getDwbm());
		}
		
		for(YwpzEntity y:list){
			YwpzEntity y1=baseMapper.selectsfdwzck(y.getDwbm());//获取开发商暂存款金额
			y1.setZckje(y1.getZckje()-y.getJe()+y.getYjsjje());
			baseMapper.updatedwzck(y1);//改开发商的暂存款金额
			ZhxxEntity z=baseMapper.selectzhxx(y.getDhbm());
			z.setDwze(z.getDwze()-y.getJe()+y.getYjsjje());
			baseMapper.updatezhxxdwze(z);//改楼栋的已交金额
			baseMapper.updateywpzje(y);//改ywpz表je
			baseMapper.updateyjmxje(y);//改yjmx表je
		}
	}

	@Override
	public void lgjexc() {
		Double a=1.0;
		Double b=102.0;
		Double c=a-b;
		if(c>=-100&&c<=100){
			System.out.println("1");
		}else{
			System.out.println("2");
		}
	}

	@Override
	public void zhxxyjje2(ZhxxEntity z) {
		
		String jsbz = z.getJsbz();
		if ("按面积".equals(jsbz)) {
			Double je = z.getZmj() * z.getJkbz();
			Double Yjje = (double) Math.round(je);
			z.setYjje(Yjje);
			baseMapper.updatezhxxyjje(z);
		}else if("按金额".equals(jsbz)){
			Double je = z.getZje() * z.getJkbz();
			Double Yjje = (double) Math.round(je);
			z.setYjje(Yjje);
			baseMapper.updatezhxxyjje(z);
		}
		
	}

	@Override
	public void updatezhxxyjje2(ZhxxEntity z) {
		
		baseMapper.updatezhxxyjje(z);
		
	}

}
