package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XzdyFwxxSdEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.GrwxzjfhService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 个人维修资金复核
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/grwxzjfh")
@Api(tags = "个人维修资金复核模块")
public class GrwxzjfhController {

	@Autowired
	private GrwxzjfhService grwxzjfhService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(个人维修资金复核查询)", response = YwpzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", grwxzjfhService.queryByPage(pageNum, pageSize, ywpzEntity));
	}

	@Login
	@PostMapping("/selectck")
	@ApiOperation(value = "查看按钮", notes = "在此补充接口详细注释...", response = YwpzEntity.class)
	public R select(@RequestBody String fwbm) {

		return R.ok().put("data", grwxzjfhService.selectgrwxFh(fwbm));
	}

	@Login
	@PostMapping("/updatefh")
	@ApiOperation(value = "复核按钮", notes = "在此补充接口详细注释...", response = XzdyFwxxSdEntity.class)
	public R updatefh(@RequestBody List<DhbmyjEntity> dhyjs) {
		grwxzjfhService.updateFh(dhyjs);
		return R.ok();
	}

	@Login
	@PostMapping("/updateqxfh")
	@ApiOperation(value = "取消复核按钮", notes = "在此补充接口详细注释...", response = XzdyFwxxSdEntity.class)
	public R updateqxfh(@RequestBody List<DhbmyjEntity> dhyjs) {
		grwxzjfhService.updateQxfh(dhyjs);
		return R.ok();
	}

	@Login
	@PostMapping("/selectdjld")
	@ApiOperation(value = "二级联动下拉框", notes = "在此补充接口详细注释...", response = XlkEntity.class)
	public R selectdjld(@RequestBody Map<String, String> map) {

		return R.ok().put("list", grwxzjfhService.selectdjld(map));
	}

}
