package io.renren.modules.app.dao;

import io.renren.modules.app.entity.SysDictEntity;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 数据字典表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-01 11:31:35
 */
@Mapper
public interface SysDictDao extends BaseMapper<SysDictEntity> {

    /**
     * 分页模糊查询
     * @param sysDictEntity
     * @return
     */
    List<SysDictEntity> queryByPage(SysDictEntity sysDictEntity);

    /**
     * 字典名称下拉列表（查询用）
     */

    List<SysDictEntity> queryList(SysDictEntity sysDictEntity);


    /**
     * 字典名称下拉列表（本页面查询用）
     */

    List<SysDictEntity> queryListLocal(SysDictEntity sysDictEntity);
    
    /**
     * 查询字典码是否已有
     * @param sysDictEntity
     * @return
     */
    int selectCode(SysDictEntity sysDictEntity);


    /**
     * 字典类型下拉框
     * @return
     */
    List<SysDictEntity> zdxlk();
    
    /**
     * 字典表插入
     * @param sysDictEntity
     * @return
     */
    int insertZDInfo(SysDictEntity sysDictEntity);
    
    /**
     * 获取最大id
     * @param type
     * @return
     */
    String selectMaxID(@Param("type")String type);

}
