package io.renren.modules.app.service.impl;


import com.alibaba.druid.sql.ast.statement.SQLIfStatement.Else;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.HKmDao;
import io.renren.modules.app.entity.HKmEntity;
import io.renren.modules.app.service.HKmService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


@Service("hKmService")
public class HKmServiceImpl extends ServiceImpl<HKmDao, HKmEntity> implements HKmService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param hKmEntity
     * @return
     */
    @Override
    public PageInfo<HKmEntity> queryByPage(Integer pageNum, Integer pageSize, HKmEntity hKmEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<HKmEntity> hKmEntitys = baseMapper.queryByPage(hKmEntity);
        PageInfo<HKmEntity> pageInfo = new PageInfo<HKmEntity>(hKmEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }

	@Override
	public List<HKmEntity> selectejcd(HKmEntity hKmEntity) {
		List<HKmEntity> list=new ArrayList<HKmEntity>();
		String kjqj = hKmEntity.getKjqj();
		String gdrq = "2020-12";// 切换新旧科目的临界日期
		int res = kjqj.compareTo(gdrq);
		if (res > 0) {//新科目
			list=baseMapper.selectejcd2(hKmEntity);
		}else if(res<=0){//旧科目
			list=baseMapper.selectejcd(hKmEntity);
		}
		
		return list;
	}

	@Override
	public List<HKmEntity> selectsjcd(HKmEntity hKmEntity) {
		List<HKmEntity> list=new ArrayList<HKmEntity>();
		String kjqj = hKmEntity.getKjqj();
		String gdrq = "2020-12";// 切换新旧科目的临界日期
		int res = kjqj.compareTo(gdrq);
		if (res > 0) {//新科目
			if("1001".equals(hKmEntity.getKm())){
				list=baseMapper.selectsjcd1022(hKmEntity);
			}else if("3001".equals(hKmEntity.getKm())){
				list=baseMapper.selectsjcd10222(hKmEntity);
			}else if("4001".equals(hKmEntity.getKm())){
				list=baseMapper.selectsjcd102222(hKmEntity);
			}
		}else if(res<=0){//旧科目
			if("101".equals(hKmEntity.getKm())){
				list=baseMapper.selectsjcd102(hKmEntity);
			}else if("201".equals(hKmEntity.getKm())){
				list=baseMapper.selectsjcd110(hKmEntity);
			}else if("311".equals(hKmEntity.getKm())){
				list=baseMapper.selectsjcd207(hKmEntity);
			}else if("401".equals(hKmEntity.getKm())){
				list=baseMapper.selectsjcd211(hKmEntity);
			}else if("411".equals(hKmEntity.getKm())){
				list=baseMapper.selectsjcd411(hKmEntity);
			}
		}
		
		return list;
	}

	@Override
	public List<HKmEntity> selectsijcd2(HKmEntity hKmEntity) {
		List<HKmEntity> listf=new ArrayList<HKmEntity>();
		String kjqj = hKmEntity.getKjqj();
		String gdrq = "2020-12";// 切换新旧科目的临界日期
		int res = kjqj.compareTo(gdrq);
		if (res > 0) {//新科目
			List<HKmEntity> list102=baseMapper.selectsjcd1022(hKmEntity);
//			List<HKmEntity> list211=baseMapper.selectsjcd10222(hKmEntity);
			for(HKmEntity h102:list102){
				if(h102.getKm().equals(hKmEntity.getKm())){
					listf=baseMapper.select4ji2(hKmEntity);
					for(int i=0;i<listf.size();i++){
						HKmEntity a=baseMapper.select4ji62(hKmEntity);
						listf.get(i).setKmmc("银行存款-"+a.getKmmc()+"-"+listf.get(i).getKmmc());
					}
				}
			}
//			for(HKmEntity h211:list211){
//				if(h211.getKm().equals(hKmEntity.getKm())){
//					listf=baseMapper.select4ji2(hKmEntity);
//					for(int i=0;i<listf.size();i++){
//						HKmEntity a=baseMapper.select4ji62(hKmEntity);
//						listf.get(i).setKmmc("住宅公共维修资金-"+a.getKmmc()+"-"+listf.get(i).getKmmc());
//					}
//				}
//			}
		}else if(res<=0){//旧科目
			List<HKmEntity> list102=baseMapper.selectsjcd102(hKmEntity);
			List<HKmEntity> list211=baseMapper.selectsjcd110(hKmEntity);
			for(HKmEntity h102:list102){
				if(h102.getKm().equals(hKmEntity.getKm())){
					listf=baseMapper.select4ji(hKmEntity);
					for(int i=0;i<listf.size();i++){
						HKmEntity a=baseMapper.select4ji6(hKmEntity);
						listf.get(i).setKmmc("银行存款-"+a.getKmmc()+"-"+listf.get(i).getKmmc());
					}
				}
			}
			for(HKmEntity h211:list211){
				if(h211.getKm().equals(hKmEntity.getKm())){
					listf=baseMapper.select4ji(hKmEntity);
					for(int i=0;i<listf.size();i++){
						HKmEntity a=baseMapper.select4ji6(hKmEntity);
						listf.get(i).setKmmc("住宅公共维修资金-"+a.getKmmc()+"-"+listf.get(i).getKmmc());
					}
				}
			}
		}
		
		
		
		
		return listf;
	}
	
	


}