package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.XqxxDao;
import io.renren.modules.app.entity.XqxxEntity;
import io.renren.modules.app.entity.XqxxEntity2;
import io.renren.modules.app.service.XqxxService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service("xqxxService")
public class XqxxServiceImpl extends ServiceImpl<XqxxDao, XqxxEntity> implements XqxxService {

	// GIS查询小区所有信息
	@Override
	public PageInfo<XqxxEntity> queryGisZs() {
		List<XqxxEntity> xqxxEntitys = baseMapper.queryGisZs();
		PageInfo<XqxxEntity> pageInfo = new PageInfo<XqxxEntity>(xqxxEntitys);
		return pageInfo;
	}

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param xqxxEntity
	 * @return
	 */
	@Override
	public PageInfo<XqxxEntity2> queryByPage(Integer pageNum, Integer pageSize, XqxxEntity xqxxEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<XqxxEntity2> xqxxEntitys = baseMapper.queryByPage(xqxxEntity);
		PageInfo<XqxxEntity2> pageInfo = new PageInfo<XqxxEntity2>(xqxxEntitys);
		return pageInfo;
	}

	/**
	 * 单个或批量删除
	 * 
	 * @param ids
	 */
	@Override
	public void deleteBatch(String[] ids) {
		this.deleteBatchIds(Arrays.asList(ids));
	}

	@Override
	public String queryxqbm() {
		return baseMapper.queryxqbm();
	}

}