/*
 * Decompiled with CFR 0.152.
 */
package io.renren.common.aspect;

import io.renren.common.exception.RRException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class RedisAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${spring.redis.open: false}")
    private boolean open;

    @Around(value="execution(* io.renren.common.utils.RedisUtils.*(..))")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        if (this.open) {
            try {
                result = point.proceed();
            }
            catch (Exception e) {
                this.logger.error("redis error", (Throwable)e);
                throw new RRException("Redis\u670d\u52a1\u5f02\u5e38");
            }
        }
        return result;
    }
}

