/*
 * Decompiled with CFR 0.152.
 */
package io.renren.datasources.aspect;

import io.renren.datasources.DynamicDataSource;
import io.renren.datasources.annotation.DataSource;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataSourceAspect
implements Ordered {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(io.renren.datasources.annotation.DataSource)")
    public void dataSourcePointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="dataSourcePointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        DataSource ds = method.getAnnotation(DataSource.class);
        if (ds == null) {
            DynamicDataSource.setDataSource((String)"first");
            this.logger.debug("set datasource is first");
        } else {
            DynamicDataSource.setDataSource((String)ds.name());
            this.logger.debug("set datasource is " + ds.name());
        }
        try {
            Object object = point.proceed();
            return object;
        }
        finally {
            DynamicDataSource.clearDataSource();
            this.logger.debug("clean datasource");
        }
    }

    public int getOrder() {
        return 1;
    }
}

