/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.common.validator.ValidatorUtils;
import io.renren.modules.app.entity.UserEntity;
import io.renren.modules.app.form.LoginForm;
import io.renren.modules.app.service.UserService;
import io.renren.modules.app.utils.JwtUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
@Api(tags={"APP\u767b\u5f55\u63a5\u53e3"})
public class AppLoginController {
    @Autowired
    private UserService userService;
    @Autowired
    private JwtUtils jwtUtils;

    @PostMapping(value={"login"})
    @ApiOperation(value="\u767b\u5f55", notes="\u767b\u5f55\u540e\u4fdd\u5b58token\uff0c\u4ee5\u540e\u6bcf\u6b21\u8bf7\u6c42\u63a5\u53e3\u5fc5\u987b\u643a\u5e26\u6b63\u786e\u7684token\uff01", response=UserEntity.class)
    public R login(@RequestBody LoginForm form) {
        ValidatorUtils.validateEntity((Object)form, (Class[])new Class[0]);
        long userId = this.userService.login(form);
        String token = this.jwtUtils.generateToken(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", token);
        map.put("expire", this.jwtUtils.getExpire());
        return R.ok(map);
    }
}

