/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.app.interceptor;

import io.jsonwebtoken.Claims;
import io.renren.common.exception.RRException;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.utils.JwtUtils;
import io.renren.modules.sys.service.SysUserService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class AuthorizationInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private SysUserService sysUserService;
    public static final String USER_KEY = "userId";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        Login annotation = (Login)((HandlerMethod)handler).getMethodAnnotation(Login.class);
        if (annotation == null) {
            return true;
        }
        String token = request.getHeader(this.jwtUtils.getHeader());
        if (StringUtils.isBlank((String)token)) {
            token = request.getParameter(this.jwtUtils.getHeader());
        }
        if (StringUtils.isBlank((String)token)) {
            throw new RRException(this.jwtUtils.getHeader() + "\u4e0d\u80fd\u4e3a\u7a7a", HttpStatus.UNAUTHORIZED.value());
        }
        Claims claims = this.jwtUtils.getClaimByToken(token);
        if (claims == null || this.jwtUtils.isTokenExpired(claims.getExpiration()) || !this.sysUserService.checkToken(token)) {
            throw new RRException(this.jwtUtils.getHeader() + "\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", HttpStatus.UNAUTHORIZED.value());
        }
        request.setAttribute(USER_KEY, (Object)Long.parseLong(claims.getSubject()));
        return true;
    }
}

