/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.gson.Gson;
import io.renren.common.exception.RRException;
import io.renren.common.utils.PageUtils;
import io.renren.common.utils.Query;
import io.renren.modules.app.dao.ConfigDao;
import io.renren.modules.app.entity.ConfigEntity;
import io.renren.modules.app.service.ConfigService;
import io.renren.modules.app.utils.ConfigRedis;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ConfigService")
public class ConfigServiceImpl
extends ServiceImpl<ConfigDao, ConfigEntity>
implements ConfigService {
    @Autowired
    private ConfigRedis ConfigRedis;

    public PageUtils queryPage(Map<String, Object> params) {
        String paramKey = (String)params.get("paramKey");
        Page page = this.selectPage(new Query(params).getPage(), new EntityWrapper().like(StringUtils.isNotBlank((String)paramKey), "param_key", paramKey).eq("status", (Object)1));
        return new PageUtils(page);
    }

    public void save(ConfigEntity config) {
        this.insert((Object)config);
        this.ConfigRedis.saveOrUpdate(config);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ConfigEntity config) {
        this.updateAllColumnById((Object)config);
        this.ConfigRedis.saveOrUpdate(config);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateValueByKey(String key, String value) {
        ((ConfigDao)this.baseMapper).updateValueByKey(key, value);
        this.ConfigRedis.delete(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(Long[] ids) {
        for (Long id : ids) {
            ConfigEntity config = (ConfigEntity)this.selectById((Serializable)id);
            this.ConfigRedis.delete(config.getParamKey());
        }
        this.deleteBatchIds(Arrays.asList(ids));
    }

    public String getValue(String key) {
        ConfigEntity config = this.ConfigRedis.get(key);
        if (config == null) {
            config = ((ConfigDao)this.baseMapper).queryByKey(key);
            this.ConfigRedis.saveOrUpdate(config);
        }
        return config == null ? null : config.getParamValue();
    }

    public <T> T getConfigObject(String key, Class<T> clazz) {
        String value = this.getValue(key);
        if (StringUtils.isNotBlank((String)value)) {
            return (T)new Gson().fromJson(value, clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RRException("\u83b7\u53d6\u53c2\u6570\u5931\u8d25");
        }
    }
}

