/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.job.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import io.renren.common.utils.Constant;
import io.renren.common.utils.PageUtils;
import io.renren.common.utils.Query;
import io.renren.modules.job.dao.ScheduleJobDao;
import io.renren.modules.job.entity.ScheduleJobEntity;
import io.renren.modules.job.service.ScheduleJobService;
import io.renren.modules.job.utils.ScheduleUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scheduleJobService")
public class ScheduleJobServiceImpl
extends ServiceImpl<ScheduleJobDao, ScheduleJobEntity>
implements ScheduleJobService {
    @Autowired
    private Scheduler scheduler;

    @PostConstruct
    public void init() {
        List scheduleJobList = this.selectList(null);
        for (ScheduleJobEntity scheduleJob : scheduleJobList) {
            CronTrigger cronTrigger = ScheduleUtils.getCronTrigger((Scheduler)this.scheduler, (Long)scheduleJob.getJobId());
            if (cronTrigger == null) {
                ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)scheduleJob);
                continue;
            }
            ScheduleUtils.updateScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)scheduleJob);
        }
    }

    public PageUtils queryPage(Map<String, Object> params) {
        String beanName = (String)params.get("beanName");
        Page page = this.selectPage(new Query(params).getPage(), new EntityWrapper().like(StringUtils.isNotBlank((String)beanName), "bean_name", beanName));
        return new PageUtils(page);
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(ScheduleJobEntity scheduleJob) {
        scheduleJob.setCreateTime(new Date());
        scheduleJob.setStatus(Integer.valueOf(Constant.ScheduleStatus.NORMAL.getValue()));
        this.insert((Object)scheduleJob);
        ScheduleUtils.createScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)scheduleJob);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ScheduleJobEntity scheduleJob) {
        ScheduleUtils.updateScheduleJob((Scheduler)this.scheduler, (ScheduleJobEntity)scheduleJob);
        this.updateById((Object)scheduleJob);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(Long[] jobIds) {
        for (Long jobId : jobIds) {
            ScheduleUtils.deleteScheduleJob((Scheduler)this.scheduler, (Long)jobId);
        }
        this.deleteBatchIds(Arrays.asList(jobIds));
    }

    public int updateBatch(Long[] jobIds, int status) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", jobIds);
        map.put("status", status);
        return ((ScheduleJobDao)this.baseMapper).updateBatch(map);
    }

    @Transactional(rollbackFor={Exception.class})
    public void run(Long[] jobIds) {
        for (Long jobId : jobIds) {
            ScheduleUtils.run((Scheduler)this.scheduler, (ScheduleJobEntity)((ScheduleJobEntity)this.selectById((Serializable)jobId)));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void pause(Long[] jobIds) {
        for (Long jobId : jobIds) {
            ScheduleUtils.pauseJob((Scheduler)this.scheduler, (Long)jobId);
        }
        this.updateBatch(jobIds, Constant.ScheduleStatus.PAUSE.getValue());
    }

    @Transactional(rollbackFor={Exception.class})
    public void resume(Long[] jobIds) {
        for (Long jobId : jobIds) {
            ScheduleUtils.resumeJob((Scheduler)this.scheduler, (Long)jobId);
        }
        this.updateBatch(jobIds, Constant.ScheduleStatus.NORMAL.getValue());
    }
}

