/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.oss.cloud;

import io.renren.common.utils.Constant;
import io.renren.common.utils.SpringContextUtils;
import io.renren.modules.oss.cloud.AliyunCloudStorageService;
import io.renren.modules.oss.cloud.CloudStorageConfig;
import io.renren.modules.oss.cloud.CloudStorageService;
import io.renren.modules.oss.cloud.QcloudCloudStorageService;
import io.renren.modules.oss.cloud.QiniuCloudStorageService;
import io.renren.modules.sys.service.SysConfigService;

public final class OSSFactory {
    private static SysConfigService sysConfigService = (SysConfigService)SpringContextUtils.getBean((String)"sysConfigService");

    public static CloudStorageService build() {
        CloudStorageConfig config = (CloudStorageConfig)sysConfigService.getConfigObject("CLOUD_STORAGE_CONFIG_KEY", CloudStorageConfig.class);
        if (config.getType().intValue() == Constant.CloudService.QINIU.getValue()) {
            return new QiniuCloudStorageService(config);
        }
        if (config.getType().intValue() == Constant.CloudService.ALIYUN.getValue()) {
            return new AliyunCloudStorageService(config);
        }
        if (config.getType().intValue() == Constant.CloudService.QCLOUD.getValue()) {
            return new QcloudCloudStorageService(config);
        }
        return null;
    }
}

