/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.oss.cloud;

import com.alibaba.fastjson.JSONObject;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.sign.Credentials;
import io.renren.common.exception.RRException;
import io.renren.modules.oss.cloud.CloudStorageConfig;
import io.renren.modules.oss.cloud.CloudStorageService;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class QcloudCloudStorageService
extends CloudStorageService {
    private COSClient client;

    public QcloudCloudStorageService(CloudStorageConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        Credentials credentials = new Credentials((long)this.config.getQcloudAppId().intValue(), this.config.getQcloudSecretId(), this.config.getQcloudSecretKey());
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setRegion(this.config.getQcloudRegion());
        this.client = new COSClient(clientConfig, credentials);
    }

    public String upload(byte[] data, String path) {
        UploadFileRequest request;
        String response;
        JSONObject jsonObject;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((jsonObject = JSONObject.parseObject((String)(response = this.client.uploadFile(request = new UploadFileRequest(this.config.getQcloudBucketName(), path, data))))).getInteger("code") != 0) {
            throw new RRException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c" + jsonObject.getString("message"));
        }
        return this.config.getQcloudDomain() + path;
    }

    public String upload(InputStream inputStream, String path) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            return this.upload(data, path);
        }
        catch (IOException e) {
            throw new RRException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public String uploadSuffix(byte[] data, String suffix) {
        return this.upload(data, this.getPath(this.config.getQcloudPrefix(), suffix));
    }

    public String uploadSuffix(InputStream inputStream, String suffix) {
        return this.upload(inputStream, this.getPath(this.config.getQcloudPrefix(), suffix));
    }
}

