/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.oss.cloud;

import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import io.renren.common.exception.RRException;
import io.renren.modules.oss.cloud.CloudStorageConfig;
import io.renren.modules.oss.cloud.CloudStorageService;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class QiniuCloudStorageService
extends CloudStorageService {
    private UploadManager uploadManager;
    private String token;

    public QiniuCloudStorageService(CloudStorageConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.uploadManager = new UploadManager(new Configuration(Zone.autoZone()));
        this.token = Auth.create((String)this.config.getQiniuAccessKey(), (String)this.config.getQiniuSecretKey()).uploadToken(this.config.getQiniuBucketName());
    }

    public String upload(byte[] data, String path) {
        try {
            Response res = this.uploadManager.put(data, path, this.token);
            if (!res.isOK()) {
                throw new RuntimeException("\u4e0a\u4f20\u4e03\u725b\u51fa\u9519\uff1a" + res.toString());
            }
        }
        catch (Exception e) {
            throw new RRException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u4e03\u725b\u914d\u7f6e\u4fe1\u606f", (Throwable)e);
        }
        return this.config.getQiniuDomain() + "/" + path;
    }

    public String upload(InputStream inputStream, String path) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            return this.upload(data, path);
        }
        catch (IOException e) {
            throw new RRException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public String uploadSuffix(byte[] data, String suffix) {
        return this.upload(data, this.getPath(this.config.getQiniuPrefix(), suffix));
    }

    public String uploadSuffix(InputStream inputStream, String suffix) {
        return this.upload(inputStream, this.getPath(this.config.getQiniuPrefix(), suffix));
    }
}

