/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.oss.controller;

import com.google.gson.Gson;
import io.renren.common.exception.RRException;
import io.renren.common.utils.Constant;
import io.renren.common.utils.PageUtils;
import io.renren.common.utils.R;
import io.renren.common.validator.ValidatorUtils;
import io.renren.common.validator.group.AliyunGroup;
import io.renren.common.validator.group.QcloudGroup;
import io.renren.common.validator.group.QiniuGroup;
import io.renren.modules.oss.cloud.CloudStorageConfig;
import io.renren.modules.oss.cloud.OSSFactory;
import io.renren.modules.oss.entity.SysOssEntity;
import io.renren.modules.oss.service.SysOssService;
import io.renren.modules.sys.service.SysConfigService;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"sys/oss"})
public class SysOssController {
    @Autowired
    private SysOssService sysOssService;
    @Autowired
    private SysConfigService sysConfigService;
    private static final String KEY = "CLOUD_STORAGE_CONFIG_KEY";

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sys:oss:all"})
    public R list(@RequestParam Map<String, Object> params) {
        PageUtils page = this.sysOssService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @GetMapping(value={"/config"})
    @RequiresPermissions(value={"sys:oss:all"})
    public R config() {
        CloudStorageConfig config = (CloudStorageConfig)this.sysConfigService.getConfigObject(KEY, CloudStorageConfig.class);
        return R.ok().put("config", (Object)config);
    }

    @PostMapping(value={"/saveConfig"})
    @RequiresPermissions(value={"sys:oss:all"})
    public R saveConfig(@RequestBody CloudStorageConfig config) {
        ValidatorUtils.validateEntity((Object)config, (Class[])new Class[0]);
        if (config.getType().intValue() == Constant.CloudService.QINIU.getValue()) {
            ValidatorUtils.validateEntity((Object)config, (Class[])new Class[]{QiniuGroup.class});
        } else if (config.getType().intValue() == Constant.CloudService.ALIYUN.getValue()) {
            ValidatorUtils.validateEntity((Object)config, (Class[])new Class[]{AliyunGroup.class});
        } else if (config.getType().intValue() == Constant.CloudService.QCLOUD.getValue()) {
            ValidatorUtils.validateEntity((Object)config, (Class[])new Class[]{QcloudGroup.class});
        }
        this.sysConfigService.updateValueByKey(KEY, new Gson().toJson((Object)config));
        return R.ok();
    }

    @PostMapping(value={"/upload"})
    @RequiresPermissions(value={"sys:oss:all"})
    public R upload(@RequestParam(value="file") MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new RRException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
        String url = OSSFactory.build().uploadSuffix(file.getBytes(), suffix);
        SysOssEntity ossEntity = new SysOssEntity();
        ossEntity.setUrl(url);
        ossEntity.setCreateDate(new Date());
        this.sysOssService.insert((Object)ossEntity);
        return R.ok().put("url", (Object)url);
    }

    @PostMapping(value={"/delete"})
    @RequiresPermissions(value={"sys:oss:all"})
    public R delete(@RequestBody Long[] ids) {
        this.sysOssService.deleteBatchIds(Arrays.asList(ids));
        return R.ok();
    }
}

