/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.controller;

import io.renren.common.annotation.SysLog;
import io.renren.common.utils.PageUtils;
import io.renren.common.utils.R;
import io.renren.common.validator.ValidatorUtils;
import io.renren.modules.sys.controller.AbstractController;
import io.renren.modules.sys.entity.SysConfigEntity;
import io.renren.modules.sys.service.SysConfigService;
import java.io.Serializable;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/config"})
public class SysConfigController
extends AbstractController {
    @Autowired
    private SysConfigService sysConfigService;

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sys:config:list"})
    public R list(@RequestParam Map<String, Object> params) {
        PageUtils page = this.sysConfigService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @GetMapping(value={"/info/{id}"})
    @RequiresPermissions(value={"sys:config:info"})
    public R info(@PathVariable(value="id") Long id) {
        SysConfigEntity config = (SysConfigEntity)this.sysConfigService.selectById((Serializable)id);
        return R.ok().put("config", (Object)config);
    }

    @SysLog(value="\u4fdd\u5b58\u914d\u7f6e")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"sys:config:save"})
    public R save(@RequestBody SysConfigEntity config) {
        ValidatorUtils.validateEntity((Object)config, (Class[])new Class[0]);
        this.sysConfigService.save(config);
        return R.ok();
    }

    @SysLog(value="\u4fee\u6539\u914d\u7f6e")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"sys:config:update"})
    public R update(@RequestBody SysConfigEntity config) {
        ValidatorUtils.validateEntity((Object)config, (Class[])new Class[0]);
        this.sysConfigService.update(config);
        return R.ok();
    }

    @SysLog(value="\u5220\u9664\u914d\u7f6e")
    @PostMapping(value={"/delete"})
    @RequiresPermissions(value={"sys:config:delete"})
    public R delete(@RequestBody Long[] ids) {
        this.sysConfigService.deleteBatch(ids);
        return R.ok();
    }
}

