/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.utils.JwtUtils;
import io.renren.modules.sys.controller.AbstractController;
import io.renren.modules.sys.entity.SysUserEntity;
import io.renren.modules.sys.form.SysLoginForm;
import io.renren.modules.sys.service.SysCaptchaService;
import io.renren.modules.sys.service.SysUserService;
import io.renren.modules.sys.service.SysUserTokenService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysLoginController
extends AbstractController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserTokenService sysUserTokenService;
    @Autowired
    private SysCaptchaService sysCaptchaService;
    @Autowired
    private JwtUtils jwtUtils;

    @GetMapping(value={"captcha.jpg"})
    public void captcha(HttpServletResponse response, String uuid) throws ServletException, IOException {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setContentType("image/jpeg");
        BufferedImage image = this.sysCaptchaService.getCaptcha(uuid);
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
        IOUtils.closeQuietly((OutputStream)out);
    }

    @PostMapping(value={"/sys/login"})
    public Map<String, Object> login(@RequestBody SysLoginForm form) throws IOException {
        boolean captcha = this.sysCaptchaService.validate(form.getUuid(), form.getCaptcha());
        if (!captcha) {
            return R.error((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        SysUserEntity user = this.sysUserService.queryByLoginName(form.getLoginname());
        if (user == null || !user.getPassword().equals(new Sha256Hash((Object)form.getPassword(), (Object)user.getSalt()).toHex())) {
            return R.error((String)"\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (user.getStatus() == 0) {
            return R.error((String)"\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String token = this.jwtUtils.generateToken(user.getUserId().longValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", token);
        map.put("expire", this.jwtUtils.getExpire());
        this.sysUserTokenService.createToken(user.getUserId().longValue(), token);
        return R.ok().put("token", (Object)token).put("expire", (Object)this.jwtUtils.getExpire());
    }

    @PostMapping(value={"/sys/logout"})
    public R logout() {
        this.sysUserTokenService.logout(this.getUserId().longValue());
        return R.ok();
    }
}

