/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.controller;

import io.renren.common.annotation.SysLog;
import io.renren.common.exception.RRException;
import io.renren.common.utils.Constant;
import io.renren.common.utils.R;
import io.renren.modules.sys.controller.AbstractController;
import io.renren.modules.sys.entity.SysMenuEntity;
import io.renren.modules.sys.service.ShiroService;
import io.renren.modules.sys.service.SysMenuService;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/menu"})
public class SysMenuController
extends AbstractController {
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private ShiroService shiroService;

    @GetMapping(value={"/nav"})
    public R nav() {
        List menuList = this.sysMenuService.getUserMenuList(this.getUserId());
        Set permissions = this.shiroService.getUserPermissions(this.getUserId().longValue());
        return R.ok().put("menuList", (Object)menuList).put("permissions", (Object)permissions);
    }

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sys:menu:list"})
    public List<SysMenuEntity> list() {
        List menuList = this.sysMenuService.selectList(null);
        for (SysMenuEntity sysMenuEntity : menuList) {
            SysMenuEntity parentMenuEntity = (SysMenuEntity)this.sysMenuService.selectById((Serializable)sysMenuEntity.getParentId());
            if (parentMenuEntity == null) continue;
            sysMenuEntity.setParentName(parentMenuEntity.getName());
        }
        return menuList;
    }

    @GetMapping(value={"/select"})
    @RequiresPermissions(value={"sys:menu:select"})
    public R select() {
        List menuList = this.sysMenuService.queryNotButtonList();
        SysMenuEntity root = new SysMenuEntity();
        root.setMenuId(Long.valueOf(0L));
        root.setName("\u4e00\u7ea7\u83dc\u5355");
        root.setParentId(Long.valueOf(-1L));
        root.setOpen(Boolean.valueOf(true));
        menuList.add(root);
        return R.ok().put("menuList", (Object)menuList);
    }

    @GetMapping(value={"/info/{menuId}"})
    @RequiresPermissions(value={"sys:menu:info"})
    public R info(@PathVariable(value="menuId") Long menuId) {
        SysMenuEntity menu = (SysMenuEntity)this.sysMenuService.selectById((Serializable)menuId);
        return R.ok().put("menu", (Object)menu);
    }

    @SysLog(value="\u4fdd\u5b58\u83dc\u5355")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"sys:menu:save"})
    public R save(@RequestBody SysMenuEntity menu) {
        this.verifyForm(menu);
        this.sysMenuService.insert((Object)menu);
        return R.ok();
    }

    @SysLog(value="\u4fee\u6539\u83dc\u5355")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"sys:menu:update"})
    public R update(@RequestBody SysMenuEntity menu) {
        this.verifyForm(menu);
        this.sysMenuService.updateById((Object)menu);
        return R.ok();
    }

    @SysLog(value="\u5220\u9664\u83dc\u5355")
    @PostMapping(value={"/delete/{menuId}"})
    @RequiresPermissions(value={"sys:menu:delete"})
    public R delete(@PathVariable(value="menuId") long menuId) {
        if (menuId <= 31L) {
            return R.error((String)"\u7cfb\u7edf\u83dc\u5355\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        List menuList = this.sysMenuService.queryListParentId(Long.valueOf(menuId));
        if (menuList.size() > 0) {
            return R.error((String)"\u8bf7\u5148\u5220\u9664\u5b50\u83dc\u5355\u6216\u6309\u94ae");
        }
        this.sysMenuService.delete(Long.valueOf(menuId));
        return R.ok();
    }

    private void verifyForm(SysMenuEntity menu) {
        if (StringUtils.isBlank((String)menu.getName())) {
            throw new RRException("\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (menu.getParentId() == null) {
            throw new RRException("\u4e0a\u7ea7\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (menu.getType().intValue() == Constant.MenuType.MENU.getValue() && StringUtils.isBlank((String)menu.getUrl())) {
            throw new RRException("\u83dc\u5355URL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int parentType = Constant.MenuType.CATALOG.getValue();
        if (menu.getParentId() != 0L) {
            SysMenuEntity parentMenu = (SysMenuEntity)this.sysMenuService.selectById((Serializable)menu.getParentId());
            parentType = parentMenu.getType();
        }
        if (menu.getType().intValue() == Constant.MenuType.CATALOG.getValue() || menu.getType().intValue() == Constant.MenuType.MENU.getValue()) {
            if (parentType != Constant.MenuType.CATALOG.getValue()) {
                throw new RRException("\u4e0a\u7ea7\u83dc\u5355\u53ea\u80fd\u4e3a\u76ee\u5f55\u7c7b\u578b");
            }
            return;
        }
        if (menu.getType().intValue() == Constant.MenuType.BUTTON.getValue()) {
            if (parentType != Constant.MenuType.MENU.getValue()) {
                throw new RRException("\u4e0a\u7ea7\u83dc\u5355\u53ea\u80fd\u4e3a\u83dc\u5355\u7c7b\u578b");
            }
            return;
        }
    }
}

