/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.controller;

import io.renren.common.annotation.SysLog;
import io.renren.common.utils.PageUtils;
import io.renren.common.utils.R;
import io.renren.common.validator.Assert;
import io.renren.common.validator.ValidatorUtils;
import io.renren.common.validator.group.AddGroup;
import io.renren.common.validator.group.UpdateGroup;
import io.renren.modules.sys.controller.AbstractController;
import io.renren.modules.sys.entity.SysUserEntity;
import io.renren.modules.sys.form.PasswordForm;
import io.renren.modules.sys.service.SysUserRoleService;
import io.renren.modules.sys.service.SysUserService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/user"})
public class SysUserController
extends AbstractController {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserRoleService sysUserRoleService;

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sys:user:list"})
    public R list(@RequestParam Map<String, Object> params) {
        if (this.getUserId() != 1L) {
            params.put("createUserId", this.getUserId());
        }
        PageUtils page = this.sysUserService.queryPage(params);
        return R.ok().put("page", (Object)page);
    }

    @GetMapping(value={"/info"})
    public R info() {
        return R.ok().put("user", (Object)this.getUser());
    }

    @SysLog(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"/password"})
    public R password(@RequestBody PasswordForm form) {
        Assert.isBlank((String)form.getNewPassword(), (String)"\u65b0\u5bc6\u7801\u4e0d\u4e3a\u80fd\u7a7a");
        String password = new Sha256Hash((Object)form.getPassword(), (Object)this.getUser().getSalt()).toHex();
        String newPassword = new Sha256Hash((Object)form.getNewPassword(), (Object)this.getUser().getSalt()).toHex();
        boolean flag = this.sysUserService.updatePassword(this.getUserId(), password, newPassword);
        if (!flag) {
            return R.error((String)"\u539f\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        return R.ok();
    }

    @GetMapping(value={"/info/{userId}"})
    @RequiresPermissions(value={"sys:user:info"})
    public R info(@PathVariable(value="userId") Long userId) {
        SysUserEntity user = (SysUserEntity)this.sysUserService.selectById((Serializable)userId);
        List roleIdList = this.sysUserRoleService.queryRoleIdList(userId);
        user.setRoleIdList(roleIdList);
        return R.ok().put("user", (Object)user);
    }

    @SysLog(value="\u4fdd\u5b58\u7528\u6237")
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"sys:user:save"})
    public R save(@RequestBody SysUserEntity user) {
        ValidatorUtils.validateEntity((Object)user, (Class[])new Class[]{AddGroup.class});
        user.setLoginname(user.getLoginname());
        user.setCreateUserId(this.getUserId());
        this.sysUserService.save(user);
        return R.ok();
    }

    @SysLog(value="\u4fee\u6539\u7528\u6237")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"sys:user:update"})
    public R update(@RequestBody SysUserEntity user) {
        ValidatorUtils.validateEntity((Object)user, (Class[])new Class[]{UpdateGroup.class});
        user.setCreateUserId(this.getUserId());
        this.sysUserService.update(user);
        return R.ok();
    }

    @SysLog(value="\u5220\u9664\u7528\u6237")
    @PostMapping(value={"/delete"})
    @RequiresPermissions(value={"sys:user:delete"})
    public R delete(@RequestBody Long[] userIds) {
        if (ArrayUtils.contains((Object[])userIds, (Object)1L)) {
            return R.error((String)"\u7cfb\u7edf\u7ba1\u7406\u5458\u4e0d\u80fd\u5220\u9664");
        }
        if (ArrayUtils.contains((Object[])userIds, (Object)this.getUserId())) {
            return R.error((String)"\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u5220\u9664");
        }
        this.sysUserService.deleteBatch(userIds);
        return R.ok();
    }
}

