/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.oauth2;

import io.renren.modules.sys.entity.SysUserEntity;
import io.renren.modules.sys.entity.SysUserTokenEntity;
import io.renren.modules.sys.oauth2.OAuth2Token;
import io.renren.modules.sys.service.ShiroService;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OAuth2Realm
extends AuthorizingRealm {
    @Autowired
    private ShiroService shiroService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof OAuth2Token;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SysUserEntity user = (SysUserEntity)principals.getPrimaryPrincipal();
        Long userId = user.getUserId();
        Set permsSet = this.shiroService.getUserPermissions(userId.longValue());
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        info.setStringPermissions(permsSet);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String accessToken = (String)token.getPrincipal();
        SysUserTokenEntity tokenEntity = this.shiroService.queryByToken(accessToken);
        if (tokenEntity == null || tokenEntity.getExpireTime().getTime() < System.currentTimeMillis()) {
            throw new IncorrectCredentialsException("token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        SysUserEntity user = this.shiroService.queryUser(tokenEntity.getUserId());
        if (user.getStatus() == 0) {
            throw new LockedAccountException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)user, (Object)accessToken, this.getName());
        return info;
    }
}

