/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.code.kaptcha.Producer;
import io.renren.common.exception.RRException;
import io.renren.common.utils.DateUtils;
import io.renren.modules.sys.dao.SysCaptchaDao;
import io.renren.modules.sys.entity.SysCaptchaEntity;
import io.renren.modules.sys.service.SysCaptchaService;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysCaptchaService")
public class SysCaptchaServiceImpl
extends ServiceImpl<SysCaptchaDao, SysCaptchaEntity>
implements SysCaptchaService {
    @Autowired
    private Producer producer;

    public BufferedImage getCaptcha(String uuid) {
        if (StringUtils.isBlank((String)uuid)) {
            throw new RRException("uuid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String code = this.producer.createText();
        SysCaptchaEntity captchaEntity = new SysCaptchaEntity();
        captchaEntity.setUuid(uuid);
        captchaEntity.setCode(code);
        captchaEntity.setExpireTime(DateUtils.addDateMinutes((Date)new Date(), (int)5));
        this.insert((Object)captchaEntity);
        return this.producer.createImage(code);
    }

    public boolean validate(String uuid, String code) {
        SysCaptchaEntity captchaEntity = (SysCaptchaEntity)this.selectOne(new EntityWrapper().eq("uuid", (Object)uuid));
        if (captchaEntity == null) {
            return false;
        }
        this.deleteById((Serializable)((Object)uuid));
        return captchaEntity.getCode().equalsIgnoreCase(code) && captchaEntity.getExpireTime().getTime() >= System.currentTimeMillis();
    }
}

