/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.gson.Gson;
import io.renren.common.exception.RRException;
import io.renren.common.utils.PageUtils;
import io.renren.common.utils.Query;
import io.renren.modules.sys.dao.SysConfigDao;
import io.renren.modules.sys.entity.SysConfigEntity;
import io.renren.modules.sys.redis.SysConfigRedis;
import io.renren.modules.sys.service.SysConfigService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysConfigService")
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigDao, SysConfigEntity>
implements SysConfigService {
    @Autowired
    private SysConfigRedis sysConfigRedis;

    public PageUtils queryPage(Map<String, Object> params) {
        String paramKey = (String)params.get("paramKey");
        Page page = this.selectPage(new Query(params).getPage(), new EntityWrapper().like(StringUtils.isNotBlank((String)paramKey), "param_key", paramKey).eq("status", (Object)1));
        return new PageUtils(page);
    }

    public void save(SysConfigEntity config) {
        this.insert((Object)config);
        this.sysConfigRedis.saveOrUpdate(config);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(SysConfigEntity config) {
        this.updateAllColumnById((Object)config);
        this.sysConfigRedis.saveOrUpdate(config);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateValueByKey(String key, String value) {
        ((SysConfigDao)this.baseMapper).updateValueByKey(key, value);
        this.sysConfigRedis.delete(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(Long[] ids) {
        for (Long id : ids) {
            SysConfigEntity config = (SysConfigEntity)this.selectById((Serializable)id);
            this.sysConfigRedis.delete(config.getParamKey());
        }
        this.deleteBatchIds(Arrays.asList(ids));
    }

    public String getValue(String key) {
        SysConfigEntity config = this.sysConfigRedis.get(key);
        if (config == null) {
            config = ((SysConfigDao)this.baseMapper).queryByKey(key);
            this.sysConfigRedis.saveOrUpdate(config);
        }
        return config == null ? null : config.getParamValue();
    }

    public <T> T getConfigObject(String key, Class<T> clazz) {
        String value = this.getValue(key);
        if (StringUtils.isNotBlank((String)value)) {
            return (T)new Gson().fromJson(value, clazz);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RRException("\u83b7\u53d6\u53c2\u6570\u5931\u8d25");
        }
    }
}

