/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import io.renren.common.utils.Constant;
import io.renren.common.utils.MapUtils;
import io.renren.modules.sys.dao.SysMenuDao;
import io.renren.modules.sys.entity.SysMenuEntity;
import io.renren.modules.sys.service.SysMenuService;
import io.renren.modules.sys.service.SysRoleMenuService;
import io.renren.modules.sys.service.SysUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysMenuService")
public class SysMenuServiceImpl
extends ServiceImpl<SysMenuDao, SysMenuEntity>
implements SysMenuService {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;

    public List<SysMenuEntity> queryListParentId(Long parentId, List<Long> menuIdList) {
        List menuList = this.queryListParentId(parentId);
        if (menuIdList == null) {
            return menuList;
        }
        ArrayList<SysMenuEntity> userMenuList = new ArrayList<SysMenuEntity>();
        for (SysMenuEntity menu : menuList) {
            if (!menuIdList.contains(menu.getMenuId())) continue;
            userMenuList.add(menu);
        }
        return userMenuList;
    }

    public List<SysMenuEntity> queryListParentId(Long parentId) {
        return ((SysMenuDao)this.baseMapper).queryListParentId(parentId);
    }

    public List<SysMenuEntity> queryNotButtonList() {
        return ((SysMenuDao)this.baseMapper).queryNotButtonList();
    }

    public List<SysMenuEntity> getUserMenuList(Long userId) {
        if (userId == 1L) {
            return this.getAllMenuList(null);
        }
        return this.getAllMenuList(null);
    }

    public void delete(Long menuId) {
        this.deleteById((Serializable)menuId);
        this.sysRoleMenuService.deleteByMap((Map)new MapUtils().put("menu_id", (Object)menuId));
    }

    private List<SysMenuEntity> getAllMenuList(List<Long> menuIdList) {
        List menuList = this.queryListParentId(Long.valueOf(0L), menuIdList);
        this.getMenuTreeList(menuList, menuIdList);
        return menuList;
    }

    private List<SysMenuEntity> getMenuTreeList(List<SysMenuEntity> menuList, List<Long> menuIdList) {
        ArrayList<SysMenuEntity> subMenuList = new ArrayList<SysMenuEntity>();
        for (SysMenuEntity entity : menuList) {
            if (entity.getType().intValue() == Constant.MenuType.CATALOG.getValue()) {
                entity.setList(this.getMenuTreeList(this.queryListParentId(entity.getMenuId(), menuIdList), menuIdList));
            }
            subMenuList.add(entity);
        }
        return subMenuList;
    }
}

