/*
 * Decompiled with CFR 0.152.
 */
package io.renren.modules.sys.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import io.renren.common.exception.RRException;
import io.renren.common.utils.PageUtils;
import io.renren.common.utils.Query;
import io.renren.modules.sys.dao.SysUserDao;
import io.renren.modules.sys.entity.SysUserEntity;
import io.renren.modules.sys.service.SysRoleService;
import io.renren.modules.sys.service.SysUserRoleService;
import io.renren.modules.sys.service.SysUserService;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysUserService")
public class SysUserServiceImpl
extends ServiceImpl<SysUserDao, SysUserEntity>
implements SysUserService {
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleService sysRoleService;

    public PageUtils queryPage(Map<String, Object> params) {
        String username = (String)params.get("username");
        Long createUserId = (Long)params.get("createUserId");
        Page page = this.selectPage(new Query(params).getPage(), new EntityWrapper().like(StringUtils.isNotBlank((String)username), "username", username).eq(createUserId != null, "create_user_id", (Object)createUserId));
        return new PageUtils(page);
    }

    public List<String> queryAllPerms(Long userId) {
        return ((SysUserDao)this.baseMapper).queryAllPerms(userId);
    }

    public List<Long> queryAllMenuId(Long userId) {
        return ((SysUserDao)this.baseMapper).queryAllMenuId(userId);
    }

    public SysUserEntity queryByUserName(String username) {
        return ((SysUserDao)this.baseMapper).queryByUserName(username);
    }

    @Transactional
    public void save(SysUserEntity user) {
        user.setCreateTime(new Date());
        String salt = RandomStringUtils.randomAlphanumeric((int)20);
        user.setPassword(new Sha256Hash((Object)user.getPassword(), (Object)salt).toHex());
        user.setSalt(salt);
        this.insert((Object)user);
        this.sysUserRoleService.saveOrUpdate(user.getUserId(), user.getRoleIdList());
    }

    @Transactional
    public void update(SysUserEntity user) {
        if (StringUtils.isBlank((String)user.getPassword())) {
            user.setPassword(null);
        } else {
            user.setPassword(new Sha256Hash((Object)user.getPassword(), (Object)user.getSalt()).toHex());
        }
        this.updateById((Object)user);
        this.sysUserRoleService.saveOrUpdate(user.getUserId(), user.getRoleIdList());
    }

    public void deleteBatch(Long[] userId) {
        this.deleteBatchIds(Arrays.asList(userId));
    }

    public boolean updatePassword(Long userId, String password, String newPassword) {
        SysUserEntity userEntity = new SysUserEntity();
        userEntity.setPassword(newPassword);
        return this.update((Object)userEntity, new EntityWrapper().eq("user_id", (Object)userId).eq("password", (Object)password));
    }

    private void checkRole(SysUserEntity user) {
        if (user.getRoleIdList() == null || user.getRoleIdList().size() == 0) {
            return;
        }
        if (user.getCreateUserId() == 1L) {
            return;
        }
        List roleIdList = this.sysRoleService.queryRoleIdList(user.getCreateUserId());
        if (!roleIdList.containsAll(user.getRoleIdList())) {
            throw new RRException("\u65b0\u589e\u7528\u6237\u6240\u9009\u89d2\u8272\uff0c\u4e0d\u662f\u672c\u4eba\u521b\u5efa");
        }
    }

    public boolean checkToken(String token) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", token);
        map.put("nowTime", new Date());
        List userEntityList = ((SysUserDao)this.baseMapper).checkToken(map);
        return userEntityList.size() > 0;
    }

    public SysUserEntity queryByLoginName(String loginname) {
        return ((SysUserDao)this.baseMapper).queryByLoginName(loginname);
    }
}

