package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.FwxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 产权人信息（楼盘清册）表（房屋表）
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-26 09:43:59
 */
@RestController
@RequestMapping("app/fwxx")
@Api(tags = "产权人信息（楼盘清册）表（房屋表）模块(房屋信息)")
public class FwxxController {

	@Autowired
	private FwxxService fwxxService;

	// 查询房屋图
	@GetMapping("queryFwjh")
	@ApiOperation(value = "列表", notes = "房屋列表", response = FwxxEntity.class)
	public R queryFwjh(FwxxEntity fwxxEntity) {
		return R.ok().put("data", fwxxService.queryFwjh(fwxxEntity));
	}

	// 根据单元查询出房屋列表
	// @Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = FwxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, FwxxEntity fwxxEntity) {
		// 查询所有的房屋
		return R.ok().put("data", fwxxService.queryByPage(fwxxEntity));
	}

	// 新增房屋信息
	// @Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = FwxxEntity.class)
	public R insert(@RequestBody List<FwxxEntity> lsit) {
		// 获取楼层数
		int lcs = lsit.get(0).getLcs();
		int count = 0;
		if (lcs > 0) {
			for (int i = 0; i < lcs; i++) {
				for (int j = 0; j < lsit.size(); j++) {
					// 房屋编码
					String a = fwxxService.querydhbm();
					String c = Integer.toString(Integer.parseInt(a) + 1);
					String fwbm = c;
					// 门牌号(栋名称+单元名称+层数+房屋数)
					String mphm = lsit.get(j).getDhmc() + "-" + lsit.get(j).getDymc() + "-" + (i + 1) + "-" + (j + 1);
					// 根据房屋编码获取科目编码
					FwxxEntity dhsj = fwxxService.queryDhsj(lsit.get(j));
					if (isObjectNotEmpty(dhsj) == false) {

					} else if (dhsj != null) {
						lsit.get(j).setYzkm(dhsj.getYzkm());
					}
					// 楼层数
					lsit.get(j).setLc(i + 1);
					lsit.get(j).setFwbm(fwbm);
					lsit.get(j).setMphm(mphm);
					// fwxxService.insert(lsit.get(j));
					fwxxService.insertFwxx(lsit.get(j));
					count = count + 1;
				}
			}
		}
		ZhxxEntity zhxxEntity = fwxxService.selectzhxxhs(lsit.get(0).getDhbm());
		ZhxxEntity z = new ZhxxEntity();
		z.setHs(zhxxEntity.getHs() + count);
		z.setDhbm(lsit.get(0).getDhbm());
		fwxxService.updatezhxxhs(z);
		return R.ok();
	}

	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	@Login
	@PostMapping("/updatefwxx")
	@ApiOperation(value = "修改", notes = "修改保存房屋信息", response = FwxxEntity.class)
	public R updatefwxx(@RequestBody FwxxEntity fwxxEntity) {
		fwxxService.updateFwxx(fwxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = FwxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		fwxxService.deleteBatch(ids);
		return R.ok();
	}

	// @Login
	@PostMapping("/selectfwxxbybm")
	@ApiOperation(value = "查询此房源", notes = "根据房屋编码查此房屋信息", response = FwxxEntity.class)
	public R selectfwxxbybm(@RequestBody FwxxEntity fwxxEntity) {
		return R.ok().put("list", fwxxService.selectByXxId(fwxxEntity));
	}

	// @Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = FwxxEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {
		return R.ok().put("select", fwxxService.selectxlk(map));
	}

	@Login
	@PostMapping("/PLINSERTFwxx")
	@ApiOperation(value = "批量导入房屋信息(楼盘清册导入)", notes = "", response = FwxxEntity.class)
	public R PLINSERTFwxx(@RequestBody List<FwxxEntity> list) {
		for (FwxxEntity f : list) {
			fwxxService.PLINSERTFwxx(f);
		}

		return R.ok();
	}

	// @Login
	@PostMapping("/selectdjxxbyfw")
	@ApiOperation(value = "查询此房源单据信息", notes = "如果房屋已缴过,根据房屋编码查此房屋信息对应的个人缴交单据信息", response = YwpzEntity.class)
	public R selectdjxxbyfw(@RequestBody FwxxEntity fwxxEntity) {
		return R.ok().put("list", fwxxService.selectdjxxbyfw(fwxxEntity.getFwbm()));
	}

}
