package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.JkbzEntity;
import io.renren.modules.app.service.JkbzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 售房单位（开发商）交款标准表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 16:59:00
 */
@RestController
@RequestMapping("app/jkbz")
@Api(tags = "售房单位（开发商）交款标准表模块(售房单位交款标准设置)")
public class JkbzController {

	@Autowired
	private JkbzService jkbzService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = JkbzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, JkbzEntity jkbzEntity) {

		return R.ok().put("data", jkbzService.queryByPage(pageNum, pageSize, jkbzEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = JkbzEntity.class)
	public R insert(@RequestBody JkbzEntity jkbzEntity) {
		String a=jkbzService.querybm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String bm = b + c;
	    jkbzEntity.setBm(bm);
		jkbzService.insert(jkbzEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = JkbzEntity.class)
	public R update(@RequestBody JkbzEntity jkbzEntity) {
		jkbzService.updateById(jkbzEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = JkbzEntity.class)
	public R delete(@RequestBody String[] ids) {
		jkbzService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = JkbzEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", jkbzService.selectById(id));
	}

}
