package io.renren.modules.app.entity;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 维修基金业务临时表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-17 10:16:56
 */
@Data
@TableName("ywpz_temp")
@ApiModel(value = "维修基金业务临时表")
public class YwpzTempEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty("单据编号")
	@TableId
	private String djbh;
	@ApiModelProperty("单据类型")
	private String djlx;
	@ApiModelProperty("单据日期")
	private Date djrq;
	@ApiModelProperty("售房单位编码")
	private String dwbm;
	@ApiModelProperty("承办网点编码")
	private String cbwdbm;
	@ApiModelProperty("银行编码")
	private String bankCode;
	@ApiModelProperty("归集点编码")
	private String gzdbm;
	@ApiModelProperty("结算号")
	private String zph;
	@ApiModelProperty("")
	private Double je;
	@ApiModelProperty("操作员编码")
	private String czybm;
	@ApiModelProperty("操作员姓名")
	private String czyxm;
	@ApiModelProperty("备注")
	private String bz;
	@ApiModelProperty("凭证字")
	private String pzz;
	@ApiModelProperty("凭证号")
	private String pzh;
	@ApiModelProperty("分录序号")
	private Integer flsh;
	@ApiModelProperty("结算方式")
	private String jsfs;
	@ApiModelProperty("会计期间")
	private String kjqj;
	@ApiModelProperty("收益项目")
	private String syxm;
	@ApiModelProperty("幢号编码")
	private String dhbm;
	@ApiModelProperty("分摊方式")
	private String fpfs;
	@ApiModelProperty("业务凭证状态0未审核1已审核2审核冲帐3冲账")
	private String pzzt;
	@ApiModelProperty("")
	private String xgbm;
	@ApiModelProperty("")
	private String jkfx;
	@ApiModelProperty("审核状态0未审核1审核通过2驳回")
	private String shzt;
    //.....................
	@ApiModelProperty("幢号编码集合")
	private List<String> dhbmlist;

	@ApiModelProperty("单位名称")
	private String dwmc;
	@ApiModelProperty("结算方式")
	private String billname;
	@ApiModelProperty("银行名称")
	private String yhmc;
	@ApiModelProperty("总造价")
	private Double zje;
	@ApiModelProperty("总面积")
	private Double zmj;
	@ApiModelProperty("单位维修基金总额(已交)")
	private Double dwyjje;
	@ApiModelProperty("个人维修基金总额(已交)")
	private Double gryjje;
	@ApiModelProperty("单位交缴率")
	private Double jkbz;
	@ApiModelProperty("计算标准(0按面积,1按金额)")
	private String jsbz;
	@ApiModelProperty("幢号名称")
	private String dhmc;
	@ApiModelProperty("房屋结构")
	private String hwjg;

}
