package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.FwxxDao;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzmxEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.FwxxService;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("fwxxService")
public class FwxxServiceImpl extends ServiceImpl<FwxxDao, FwxxEntity> implements FwxxService {

	/**
	 * 分页模糊查询
	 *
	 * @param fwxxEntity
	 * @return
	 */
	@Override
	public PageInfo<FwxxEntity> queryByPage(FwxxEntity fwxxEntity) {
		// 用于放回数据
		List<FwxxEntity> fwxxEntitys = new ArrayList<FwxxEntity>();
		// 根据单元查询楼层数和户数
		FwxxEntity dyxx = baseMapper.queryDyxx(fwxxEntity);
		int hs = dyxx.getHs();
		String fwdybm = dyxx.getFwdybm();
		String dymc = dyxx.getDymc();
		String dhbm = dyxx.getDhbm();
		String dhmc = dyxx.getDhmc();
		Integer lcs = dyxx.getLcs();
		for (int i = 0; i < hs; i++) {
			// 创建对象
			FwxxEntity returnpd = new FwxxEntity();
			returnpd.setFwdybm(fwdybm);
			returnpd.setDymc(dymc);
			returnpd.setLcs(lcs);
			returnpd.setDhbm(dhbm);
			returnpd.setDhmc(dhmc);
			returnpd.setFwzsmc("第" +(i+1)+ "户");
			fwxxEntitys.add(returnpd);
		}
		PageInfo<FwxxEntity> pageInfo = new PageInfo<FwxxEntity>(fwxxEntitys);
		return pageInfo;
	}

	// 单个或批量删除
	@Override
	public void deleteBatch(String[] ids) {
		this.deleteBatchIds(Arrays.asList(ids));
	}

	// 下拉框查询
	@Override
	public List<FwxxEntity> selectxlk(Map<String, String> map) {
		List<FwxxEntity> list = new ArrayList<FwxxEntity>();
		if ("xqbm".equals(map.get("xllx"))) {
			// 查询小区
			list = baseMapper.selectxq();
		} else if ("xmbm".equals(map.get("xllx"))) {
			// 查询项目
			list = baseMapper.selectxm(map);
		} else if ("dhbm".equals(map.get("xllx"))) {
			// 查询楼栋
			list = baseMapper.selectlz(map);
		} else if ("dybm".equals(map.get("xllx"))) {
			// 查询单元
			list = baseMapper.selectdy(map);
		} else if ("hx".equals(map.get("xllx"))) {
			// 户型
			list = baseMapper.hx(map);
		} else if ("fwxz".equals(map.get("xllx"))) {
			// 房屋性质
			list = baseMapper.fmxz(map);
		}else if("mhxq".equals(map.get("MHXQ"))){
			list=baseMapper.selectmhxq(map.get("pt"));
		}

		return list;
	}

	// 获取编码
	@Override
	public String querydhbm() {
		return baseMapper.querydhbm();
	}

	// 单个查询
	@Override
	public FwxxEntity selectByXxId(FwxxEntity fwxxEntity) {
		FwxxEntity f=baseMapper.selectByXxId(fwxxEntity);
		YwpzmxEntity mm=baseMapper.selectfwsfjq(f.getFwbm());
		Double yjiao=0.0;
		if(isObjectNotEmpty(mm)==false){
			yjiao=0.0;
		}else{
			yjiao=mm.getJe();
		}
		f.setYjjiao(yjiao);
		return f;
	}

	// 修改
	@Override
	public void updateFwxx(FwxxEntity fwxxEntity) {
		baseMapper.updateFwxx(fwxxEntity);
	}

	// 新增
	@Override
	public void insertFwxx(FwxxEntity fwxxEntity) {
		baseMapper.insertFwxx(fwxxEntity);
	}

	// 查询房屋图
	@Override
	public List<Map<String, Object>> queryFwjh(FwxxEntity fwxxEntity) {
		// 返回list集合
		List<Map<String, Object>> returnlist = new ArrayList<Map<String, Object>>();
		// 根据栋号获取单元
		List<FwxxEntity> dhlist = baseMapper.queryFwjhDy(fwxxEntity);
		for (int i = 0; i < dhlist.size(); i++) {
			// 返回Map集合
			Map<String, Object> map = new HashMap<String, Object>();
			// 获取单元名称
			map.put("dymc", dhlist.get(i).getDymc());
			// 获取单元编码
			Map<String, Object> pd = new HashMap<String, Object>();
			pd.put("fwdybm", dhlist.get(i).getFwdybm());
			// 根据单元编码查询房屋楼层数集合
			List<Integer> dylcs = baseMapper.queryDylcs(pd);
			// 接受楼层
			List<Object> list = new ArrayList<Object>();
			for (int j = 0; j < dylcs.size(); j++) {
				Map<String, Object> fwmap = new HashMap<String, Object>();
				// 获取楼层
				fwmap.put("lc", dylcs.get(j));
				// 获取房屋集合
				pd.put("lc", dylcs.get(j));
				List<FwxxEntity> fwlist = baseMapper.queryFwjhFw(pd);
				for(FwxxEntity f: fwlist){
					if("1".equals(f.getSfyj())){
						List<YwpzEntity> ys=baseMapper.selectfwdjbh(f.getFwbm());
							YwpzEntity y1=baseMapper.selectshzt(ys.get(0).getDjbh());
							if(isObjectNotEmpty(y1)==false||isObjectNotEmpty(ys.get(0))==false){
								
							}else{
								if("1".equals(y1.getShzt())){
									f.setSfyfh("1");
								}else{
									f.setSfyfh("0");
								}	
							}
								
					}
				}
				// 单元房屋
				fwmap.put("fwxx", fwlist);
				list.add(fwmap);
			}
			map.put("lcxx", list);
			returnlist.add(map);
		}
		return returnlist;
	}
	
	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	//新增房屋获取信息
	@Override
	public FwxxEntity queryDhsj(FwxxEntity fwxxEntity) {
		return baseMapper.queryDhsj(fwxxEntity);
	}
	
	/**
	 * 查询是否存在项目
	 */
	@Override
	public int selectIsdw(String dwbm) {
		int num = baseMapper.selectIsdw(dwbm);
		return num;
	}

	/**
	 * 删除单位
	 */
	@Override
	public int deleteFromSfdw(String dwbm) {
		int num = baseMapper.deleteFromSfdw(dwbm);
		return num;
	}

	@Override
	public void PLINSERTFwxx(FwxxEntity fwxxEntity) {
		
		baseMapper.PLINSERTFwxx(fwxxEntity);
	}

	@Override
	public void updatezhxxhs(ZhxxEntity zhxxEntity) {
		
		baseMapper.updatezhxxhs(zhxxEntity);
	}

	@Override
	public ZhxxEntity selectzhxxhs(String id) {
		
		return baseMapper.selectzhxxhs(id);
	}

	@Override
	public List<YwpzEntity> selectdjxxbyfw(String id) {
		FwxxEntity f=baseMapper.selectfwxx(id);
		List<YwpzEntity> ys=new ArrayList<YwpzEntity>();
		if("1".equals(f.getSfyj())){
			 ys=baseMapper.selectfwdjxx(id);
		}
		return ys;
	}
}