package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.GgsssyftDao;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.GgsssyftService;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.springframework.stereotype.Service;

@Service("ggsssyftService")
public class GgsssyftServiceImpl extends ServiceImpl<GgsssyftDao, YwpzEntity> implements GgsssyftService {

	@Override
	public List<XlkEntity> selectxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			list = baseMapper.selectwygs();
		} else if ("xqbm".equals(map.get("XQBM"))) {
			list = baseMapper.selectxq();
		} else if ("xqbm2".equals(map.get("XQBM2"))) {
			list = baseMapper.selectxm(map.get("xqbmz"));
		} else if ("xmbm".equals(map.get("XMBM"))) {
			list = baseMapper.selectlz(map.get("xmbmz"));
		} else if ("skyh".equals(map.get("SKYH"))) {
			list = baseMapper.selectyh();
		} else if ("jsfs".equals(map.get("JSFS"))) {
			list = baseMapper.selectjsfs();
		} else if ("djbh".equals(map.get("DJBH"))) {
			list = baseMapper.selectftdj();
		} else if ("syxm".equals(map.get("SYXM"))) {
			list = baseMapper.selectsyxm();
		} else if ("wygs".equals(map.get("WYGS"))) {
			list = baseMapper.selectzhbywy(map.get("wygsbm"));
		} else if ("hzy".equals(map.get("HZY"))) {
//			list = baseMapper.selecthzy();
		} else if ("km".equals(map.get("KM"))) {
			list = baseMapper.selectkm(map.get("pt"));
			XlkEntity kmmc = new XlkEntity();
			for (int i = 0; i < list.size(); i++) {
				if (list.get(i).getKm().length() == 9 && "102".equals(list.get(i).getKm().substring(0, 3))) {
					kmmc = baseMapper.selectkmmc(list.get(i).getKm().substring(0, 6));
                    list.get(i).setKmmc("银行存款-"+kmmc.getKmmc()+"-"+list.get(i).getKmmc());
				}else if(list.get(i).getKm().length() == 9 && "211".equals(list.get(i).getKm().substring(0, 3))){
					kmmc = baseMapper.selectkmmc(list.get(i).getKm().substring(0, 6));
                    list.get(i).setKmmc("住宅公共维修资金-"+kmmc.getKmmc()+"-"+list.get(i).getKmmc());
				}

			}
			for(int j = 0; j < list.size(); j++){
				if("1".equals(list.get(j).getDjkm())){
					list.get(j).setXzzt("1");
				}
			}
		}else if("km2".equals(map.get("KM2"))){
			String kjqj = map.get("kjqj");
			String gdrq = "2020-12";// 切换新旧科目的临界日期
			int res = kjqj.compareTo(gdrq);
			if (res > 0) {//新科目
				list = baseMapper.selectkm22(map.get("pt"));
				XlkEntity kmmc = new XlkEntity();
				for (int i = 0; i < list.size(); i++) {
					if (list.get(i).getKm().length() == 8 && "1001".equals(list.get(i).getKm().substring(0, 4))) {
						kmmc = baseMapper.selectkmmc(list.get(i).getKm().substring(0, 6));
	                    list.get(i).setKmmc("银行存款-"+kmmc.getKmmc()+"-"+list.get(i).getKmmc());
					}else if(list.get(i).getKm().length() == 6 && "4001".equals(list.get(i).getKm().substring(0, 4))){
						kmmc = baseMapper.selectkmmc(list.get(i).getKm());
	                    list.get(i).setKmmc("交存收入-"+kmmc.getKmmc());
					}

				}
				for(int j = 0; j < list.size(); j++){
					if("1".equals(list.get(j).getDjkm())){
						list.get(j).setXzzt("1");
					}
				}
			}else if(res<=0){//旧科目
				list = baseMapper.selectkm2(map.get("pt"));
				XlkEntity kmmc = new XlkEntity();
				for (int i = 0; i < list.size(); i++) {
					if (list.get(i).getKm().length() == 9 && "101".equals(list.get(i).getKm().substring(0, 3))) {
						kmmc = baseMapper.selectkmmc(list.get(i).getKm().substring(0, 6));
	                    list.get(i).setKmmc("银行存款-"+kmmc.getKmmc()+"-"+list.get(i).getKmmc());
					}else if(list.get(i).getKm().length() == 6 && "201".equals(list.get(i).getKm().substring(0, 3))){
						kmmc = baseMapper.selectkmmc(list.get(i).getKm());
	                    list.get(i).setKmmc("商品住宅维修资金-"+kmmc.getKmmc());
					}

				}
				for(int j = 0; j < list.size(); j++){
					if("1".equals(list.get(j).getDjkm())){
						list.get(j).setXzzt("1");
					}
				}
			}
			
		}else if("km3".equals(map.get("KM3"))){
			list = baseMapper.selectkm3(map.get("pt"));
			XlkEntity kmmc = new XlkEntity();
			for (int i = 0; i < list.size(); i++) {
				if (list.get(i).getKm().length() == 9 && "101".equals(list.get(i).getKm().substring(0, 3))) {
					kmmc = baseMapper.selectkmmc(list.get(i).getKm().substring(0, 6));
                    list.get(i).setKmmc("银行存款-"+kmmc.getKmmc()+"-"+list.get(i).getKmmc());
				}else if(list.get(i).getKm().length() == 6 && "201".equals(list.get(i).getKm().substring(0, 3))){
					kmmc = baseMapper.selectkmmc(list.get(i).getKm());
                    list.get(i).setKmmc("商品住宅维修资金-"+kmmc.getKmmc());
				}else if (list.get(i).getKm().length() == 9 && "102".equals(list.get(i).getKm().substring(0, 3))) {
					kmmc = baseMapper.selectkmmc(list.get(i).getKm().substring(0, 6));
                    list.get(i).setKmmc("银行存款-"+kmmc.getKmmc()+"-"+list.get(i).getKmmc());
				}else if(list.get(i).getKm().length() == 9 && "211".equals(list.get(i).getKm().substring(0, 3))){
					kmmc = baseMapper.selectkmmc(list.get(i).getKm().substring(0, 6));
                    list.get(i).setKmmc("住宅公共维修资金-"+kmmc.getKmmc()+"-"+list.get(i).getKmmc());
				}

			}
			for(int j = 0; j < list.size(); j++){
				if("1".equals(list.get(j).getDjkm())){
					list.get(j).setXzzt("1");
				}
			}
		}
		return list;
	}

	@Override
	public PageInfo<FwxxEntity> queryByPage(Integer pageNum, Integer pageSize, ZhxxEntity zhxxEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<FwxxEntity> zhxxlists = baseMapper.queryByPage(zhxxEntity);
		PageInfo<FwxxEntity> pageInfo = new PageInfo<FwxxEntity>(zhxxlists);
		return pageInfo;
	}

	@Override
	public void insertft(YwpzEntity ywpzEntity) {
		// 获取单据编号
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);

		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "04" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "04" + temp_str1 + result;
		}
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("04");
		ywpzEntity.setShrq(temp_str);
		for (int i = 0; i < ywpzEntity.getListdhandsj().size(); i++) {
			YwpzEntity y2 = new YwpzEntity();
			y2.setDjbh(newdjbh);
			y2.setDhbm(ywpzEntity.getDhbm());
			y2.setFwbm(ywpzEntity.getListdhandsj().get(i).getFwbm());
			y2.setBjje(ywpzEntity.getListdhandsj().get(i).getFtje());
			baseMapper.insertyjftmx(y2);
			// 通过房屋编码增加fwxx表中ggsy字段的值
			FwxxEntity f = baseMapper.selectfwxxggsy(ywpzEntity.getListdhandsj().get(i).getFwbm());
			f.setGgsy(f.getGgsy() + ywpzEntity.getListdhandsj().get(i).getFtje());
			f.setDqye(f.getDqye()+ywpzEntity.getListdhandsj().get(i).getFtje());
			baseMapper.updatefwxx(f);
		}
		XlkEntity xlkEntity = baseMapper.selectdwbm(ywpzEntity.getDhbm());
		ywpzEntity.setDwbm(xlkEntity.getDwbm());
		baseMapper.insertywpz(ywpzEntity);
		// 通过幢号编码增加zhxx表中ggsy的金额
		ZhxxEntity zhxxEntity = baseMapper.selectzhxxggsy(ywpzEntity.getDhbm());
		zhxxEntity.setGgsy(zhxxEntity.getGgsy() + ywpzEntity.getJe());
		zhxxEntity.setDqye(zhxxEntity.getDqye()+ywpzEntity.getJe());
		baseMapper.updatezhxx(zhxxEntity);
	}

	@Override
	public void deleteft(YwpzEntity ywpzEntity) {
		// 1.根据传过来的单据编号删除ywpz表中的分摊记录
		baseMapper.deleteywpz(ywpzEntity.getDjbh());
		// 2.根据传过来的收益总额和dhbm减少zhxx表该幢的ggsy金额
		ZhxxEntity zhxxEntity = baseMapper.selectzhxxggsy(ywpzEntity.getDhbm());
		zhxxEntity.setGgsy(zhxxEntity.getGgsy() - ywpzEntity.getSyze());
		zhxxEntity.setDqye(zhxxEntity.getDqye()-ywpzEntity.getSyze());
		baseMapper.updatezhxx(zhxxEntity);
		// 3.根据传过来的djbh查询ywpzmx中分摊的fw记录(fwbm,bjje)，根据每一个fwbm减少fwxx表中的ggsy金额
		List<YwpzEntity> ys = baseMapper.selectywpzmxbydjbh(ywpzEntity.getDjbh());
		for (int i = 0; i < ys.size(); i++) {
			FwxxEntity f = baseMapper.selectfwxxggsy(ys.get(i).getFwbm());
			f.setGgsy(f.getGgsy() - ys.get(i).getBjje());
			f.setDqye(f.getDqye()-ys.get(i).getBjje());
			baseMapper.updatefwxx(f);
		}
		// 4.根据djbh删除ywpzmx表中分摊的记录。
		baseMapper.deleteywpzmx(ywpzEntity.getDjbh());

		// --------------------------------------------------------------------

		/*
		 * // 1.确定该分摊单据的分摊方式 String fpfs = ywpzEntity.getFpfs();
		 * 
		 * if ("1".equals(fpfs)) { // 2.若是按户分摊的： //
		 * 2.1.通过单据编号查询ywpzmx表查删除之前一共分摊的户数count1 int count1 =
		 * baseMapper.selectywpzmxcount(ywpzEntity.getDjbh()); int count2 = 0;
		 * // 2.2遍历删除，记录删除的房屋户数count2 for (int i = 0; i <
		 * ywpzEntity.getListdhandsj().size(); i++) { DhbmyjEntity d = new
		 * DhbmyjEntity();
		 * d.setDjbh(ywpzEntity.getListdhandsj().get(i).getDjbh());
		 * d.setFwbm(ywpzEntity.getListdhandsj().get(i).getFwbm());
		 * baseMapper.deletemxfw(d); count2++; } //
		 * 2.3根据该单据所分摊的总额/(删除之前总户数count1-此次删除的户数count2)=还未删除户数每一户的分摊金额newftje
		 * int count3 = count1 - count2; double newftje = ywpzEntity.getJe() /
		 * count3; // 2.4根据该单据编号查询还未删除的分摊户数的记录 List<DhbmyjEntity> ld =
		 * baseMapper.selectshengyumx(ywpzEntity.getDjbh()); //判断是否把分摊的房屋全部删除了
		 * if(ld.isEmpty()){ baseMapper.deleteywpz(ywpzEntity.getDjbh()); }else{
		 * // 2.5遍历修改这些未删除户数ftje值为newftje for (DhbmyjEntity d : ld) {
		 * d.setBjje(newftje); d.setJe(newftje); baseMapper.updateftje(d); } } }
		 * else if ("0".equals(fpfs)) { // 3.若是按面积分摊的： //
		 * 3.1根据djbh和fwbm遍历删除勾选的房屋 for (int i = 0; i <
		 * ywpzEntity.getListdhandsj().size(); i++) { DhbmyjEntity d = new
		 * DhbmyjEntity();
		 * d.setDjbh(ywpzEntity.getListdhandsj().get(i).getDjbh());
		 * d.setFwbm(ywpzEntity.getListdhandsj().get(i).getFwbm());
		 * baseMapper.deletemxfw(d); } // 3.2通过djbh查询剩下的分摊房屋的信息(包括面积)。
		 * List<DhbmyjEntity> l2 = baseMapper.selectftmj(ywpzEntity.getDjbh());
		 * if(l2.isEmpty()){ baseMapper.deleteywpz(ywpzEntity.getDjbh()); }else{
		 * // 3.3遍历剩下的房屋，将总金额按每户的面积比例逐个重新分摊 double summj = 0.0; for
		 * (DhbmyjEntity dh : l2) { // 获取剩余房屋面积和 summj = summj + dh.getMj(); }
		 * for (int j = 0; j < l2.size(); j++) { // 计算剩余每一个房屋面积占剩余总面积的比例 double
		 * dgmj = l2.get(j).getMj() / summj; // 根据收益总额重新分摊 double newft =
		 * ywpzEntity.getJe() * dgmj; DhbmyjEntity d = new DhbmyjEntity();
		 * d.setBjje(newft); d.setJe(newft); d.setDjbh(l2.get(j).getDjbh());
		 * d.setFwbm(l2.get(j).getFwbm()); baseMapper.updatemjft(d); } } }
		 */
	}

	@Override
	public YwpzEntity selectdj(Map<String, String> map) {

		return baseMapper.selectdj(map.get("djbh"));
	}

	@Override
	public List<XlkEntity> selectdjfw(Map<String, String> map) {

		return baseMapper.selectdjfw(map.get("djbh"));
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageC(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> list = baseMapper.queryByPageC(ywpzEntity);
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(list);
		return pageInfo;
	}

}
