package io.renren.modules.app.service.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.RjzDao;
import io.renren.modules.app.entity.HPzEntity;
import io.renren.modules.app.entity.HPzEntity2;
import io.renren.modules.app.entity.RjzEntity;
import io.renren.modules.app.service.RjzService;
import io.renren.modules.app.utils.MoneyUtil;

@Service("rjzService")
public class RjzServiceImpl extends ServiceImpl<RjzDao, RjzEntity> implements RjzService {

	// 日记账查询
	@Override
	public PageInfo<RjzEntity> rjzSelectByPage(Integer pageNum, Integer pageSize, RjzEntity rjzEntity)
			throws Exception {

		String qsrq = "";
		String zzrq = "";
		// zzrq
		SimpleDateFormat sj = null;
		double totalYE = 0.0;
		if (rjzEntity.getFs().equals("1")) {
			sj = new SimpleDateFormat("yyyy-MM-dd");
			Date d = sj.parse(rjzEntity.getCxrq());
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(d);
			calendar.add(calendar.DATE, -1);
			zzrq = sj.format(calendar.getTime());

			// qsrq
			qsrq = rjzEntity.getCxrq().substring(0, 7);
			qsrq = qsrq + "-01";

			RjzEntity rjzEntity2 = rjzEntity;

			rjzEntity2.setZzrq(zzrq);
			rjzEntity2.setQsrq(qsrq);

			List<RjzEntity> list = baseMapper.rjzSelect_1(rjzEntity2);
			if (list.size() > 0) {
				if (list.get(0).getKmsx().equals("0")) {
					list.get(0).setKmsxmc("借方");
				} else {
					list.get(0).setKmsxmc("贷方");
				}
			}

			for (int i = 0; i < list.size(); i++) {
				if (i == 0) {
					totalYE = Double.parseDouble(list.get(i).getQcye());
					continue;
				}

				double tmpJFJE = list.get(i).getJfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getJfje());
				double tmpDFJE = list.get(i).getDfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getDfje());

				if (list.get(i).getKmsx().equals("0")) {
					totalYE = totalYE + tmpJFJE - tmpDFJE;

					// 保留两位小数四舍五入
					BigDecimal b = new BigDecimal(totalYE);
					double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

					DecimalFormat df = new DecimalFormat("0.00");// 格式化
					String qcye = df.format(f1);

					list.get(i).setKmsxmc("借方");
					list.get(i).setQcye(qcye);
				} else {
					totalYE = totalYE - tmpJFJE + tmpDFJE;

					// 保留两位小数四舍五入
					BigDecimal b = new BigDecimal(totalYE);
					double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

					DecimalFormat df = new DecimalFormat("0.00");// 格式化
					String qcye = df.format(f1);

					list.get(i).setKmsxmc("贷方");
					list.get(i).setQcye(qcye);
				}
			}
			PageInfo<RjzEntity> pageInfo = new PageInfo<RjzEntity>(list);
			return pageInfo;
		} else {
			List<RjzEntity> list = baseMapper.rjzSelect_2(rjzEntity);
			
			if (list.size() > 0) {
				if (list.get(0).getKmsx().equals("0")) {
					list.get(0).setKmsxmc("借方");
				} else {
					list.get(0).setKmsxmc("贷方");
				}
			}

			for (int i = 0; i < list.size(); i++) {
				if (i == 0) {
					totalYE = Double.parseDouble(list.get(i).getQcye());
					continue;
				}
				
				double tmpJFJE = list.get(i).getJfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getJfje());
				double tmpDFJE = list.get(i).getDfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getDfje());

				if (list.get(i).getKmsx().equals("0")) {
					totalYE = totalYE + tmpJFJE - tmpDFJE;

					// 保留两位小数四舍五入
					BigDecimal b = new BigDecimal(totalYE);
					double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

					DecimalFormat df = new DecimalFormat("0.00");// 格式化
					String qcye = df.format(f1);

					list.get(i).setKmsxmc("借方");
					list.get(i).setQcye(qcye);
				} else {
					totalYE = totalYE - tmpJFJE + tmpDFJE;

					// 保留两位小数四舍五入
					BigDecimal b = new BigDecimal(totalYE);
					double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

					DecimalFormat df = new DecimalFormat("0.00");// 格式化
					String qcye = df.format(f1);

					list.get(i).setKmsxmc("贷方");
					list.get(i).setQcye(qcye);
				}
			}

			PageInfo<RjzEntity> pageInfo = new PageInfo<RjzEntity>(list);
			return pageInfo;
		}

	}

	public String getKmmc(String kmdm,String kmjb,String ztbm) {
		String kmmc = "";
		String kmjb1 = "";
		String _full_kmmc = "";
		String skmdm = "";
		int len = 0;
		int len3 = 0;

		if (kmjb == null) {
			return kmmc;
		}
		len3 = 1;
		len = 0;
		
		
		while (len3 <= kmjb.length() && len < kmdm.length()) {
			kmjb1 = baseMapper.select_kmjb2(kmjb, len3+"");
			len = len + Integer.parseInt(kmjb1);
			if("0003".equals(ztbm)){
           	 if(len==9){
                	len=len-1;
                }
           }
			if (skmdm != kmdm.trim().substring(1, len)) {
				if("0003".equals(ztbm)&&len==3){
            		len=len+1;
            		kmmc = baseMapper.select_kmmc(ztbm, kmdm, len);
            		len=len-1;
            	}else if("0003".equals(ztbm)&&len==6){
            		kmmc = baseMapper.select_kmmc(ztbm, kmdm, len);
            	}else{
            		kmmc = baseMapper.select_kmmc(ztbm, kmdm, len);
            	}
				skmdm = kmdm.trim().substring(1, len);
				_full_kmmc = _full_kmmc + kmmc+"-";
			}
			if(kmdm.length()==4){
            	break;
            }
			len3 = len3 + 1;
		}
		
		_full_kmmc = _full_kmmc.substring(0, _full_kmmc.length()-1);
		
		return _full_kmmc;

	}

	//查询凭证记录
	@Override
	public List<HPzEntity2> pzjlSelect(HPzEntity2 HPzEntity2) {
		String kmdmmc = "";
		String km = "";
		Double df = 0.0;
		Double jf = 0.0;
		HPzEntity2 hPzEntity = new HPzEntity2(); 
//		String kmjb = baseMapper.select_kmjb(HPzEntity2.getZtbm());
		List<HPzEntity2> list2 = baseMapper.select_pz(HPzEntity2);
		for (int i = 0; i < list2.size(); i++) {
			df = df + list2.get(i).getDfje();
			jf = jf + list2.get(i).getJfje();
			list2.get(i).setZdfje(df.toString());
			list2.get(i).setZjfje(jf.toString());
			km = list2.get(i).getKm();
			kmdmmc = getKmmc(km, "333", HPzEntity2.getZtbm());
			list2.get(i).setKmdmmc(kmdmmc);
		}
		if ("0.0".equals(df)) {

		} else {
			hPzEntity.setJedx(MoneyUtil.toChinese(df.toString()));
		}
		hPzEntity.setZdfje(df.toString());
		hPzEntity.setZjfje(jf.toString());
		list2.add(hPzEntity);
		return list2;
	}

}
