package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.WxjlbDao;
import io.renren.modules.app.entity.WxjlbEntity;
import io.renren.modules.app.service.WxjlbService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;


@Service("wxjlbService")
public class WxjlbServiceImpl extends ServiceImpl<WxjlbDao, WxjlbEntity> implements WxjlbService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param wxjlbEntity
     * @return
     */
    @Override
    public PageInfo<WxjlbEntity> queryByPage(Integer pageNum, Integer pageSize, WxjlbEntity wxjlbEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<WxjlbEntity> wxjlbEntitys = baseMapper.queryByPage(wxjlbEntity);
        PageInfo<WxjlbEntity> pageInfo = new PageInfo<WxjlbEntity>(wxjlbEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }

	@Override
	public void deleteSqdbh(Map map) {
		// TODO Auto-generated method stub
		this.deleteSqdbh(map);
	}


}